##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2008/12/25
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import os
import sys
import urllib
import pickle


def readFile(filename, debug=0, lines=0):
    """
    Read the given file, if lines=1 returns list
    """

    try:
        if debug:
            print "Reading from file :", filename
        file_handle = open(filename, 'r')

        if lines:
            data = file_handle.readlines()
        else:
            data = file_handle.read()

        file_handle.close()
        return data

    except Exception, msg:
        print "Error in Reading File : ", filename
        print "Exception in : utils -> readFile() method."
        sys.exit(msg)


def writeFile(filename, data,  debug=0):
    """
    Write data to the given file
    """

    try:
        if debug:
            print "Writing to file :", filename
        file_handle = open(filename, 'w')
        file_handle.write(data)
        file_handle.close()

    except Exception, msg:
        print "Error in Writing to file : ", filename
        print "Exception in : utils -> writeFile() method."
        sys.exit(msg)


def fetchFiles(url, file_name, debug=0):
    """
    Retrive the content from the given URL, and save to the specified cache
    directory
    """

    try:
        url_open = urllib.URLopener()

        if debug:
            print "Retrieving content from : ", url

        url_open.retrieve(url, file_name)

        return file_name

    except Exception, msg:
        sys.exit(msg)


def stringFormat(file, debug=0):
    """
    Returns properly formatted string
    """

    lines = ''

    try:
        if debug:
            print "Reading and Formatting File : ", file

        lines = readFile(file, debug, lines=1)
        lines = "".join(lines)
        return(lines)

    except Exception, msg:
        print "Exception in : utils -> stringFormat() method"
        sys.exit(msg)


def removeDups(list_):
    """
    Remove duplicates from a list
    """

    tmp = []
    if not list_:
        return tmp

    for i in list_:
       i = i.strip()
       if i not in tmp:
           tmp.append(i)

    return tmp


def stripIt(strip_list, strip_val):
    """
    Returns Stripped list from list
    """
    if not strip_list:
        return []

    striped_list = []
    if type(strip_val) == list:
        for i in strip_list:
            for j in strip_val:
                i = i.replace(j, '')
            striped_list.append(i)
    elif type(strip_val) == str:
        for i in strip_list:
            striped_list.append(i.replace(strip_val, ''))

    return striped_list


def getHTMLCon(url, debug=0):
    """
    Returns Contents, Given URL
    """

    if not url:
        return None
    ptr = urllib.urlopen(url)
    data = ptr.read()
    ptr.close()
    return data


def loadPickle(file_name, debug=0):
    """
    Load pickle file, given path
    """
    if not file_name:
        return None
    try:
        return pickle.load(open(file_name, 'r'))
    except Exception, msg:
        return None


def dumpPickle(data, file_name, debug=0):
    """
    Dump object into the file
    """
    try:
        pickle.dump(data, open(file_name, 'w'))
        return True
    except Exception, msg:
        return False


def formatMultiLines(data, debug=0):
    """
    Format the lines to 79 characters
    """

    tmp = ''
    formated_data = ''

    data = data.strip()
    for i in data.split():
        if (len(tmp) + len(i)) >= 77:
          formated_data += tmp + '\n' + '  '
          tmp = ''
        tmp = tmp + i + ' '

    formated_data += tmp 

    return formated_data


def createDir(path, debug=0):
    """ 
    Create Directory, If not exists 
    """

    if not path:
        if debug:
            print 'Path not passed to _createDir() Function'
        return None

    if not os.path.exists(path):
        os.mkdir(path)

    return True
