static_dir=static
install_dir=$(pwd)/install
openvas_dir=../openvas-client-0.9.1
sladinstaller_dir=../sladinstaller-1.1.win
gtk_prefix=$(pkg-config --variable=prefix gtk+-win32-2.0)
innosetup=C:/Programme/InnoSetup5/iscc.exe


init() {
    echo rm -rf $install_dir
    rm -rf $install_dir

    ( cd $openvas_dir ; make distclean ; CFLAGS=-mms-bitfields LDFLAGS=-mwindows ./configure --prefix=c:/cygwin/home/boss/openvas-install ; make ; cd po ; make )
}

copy_static() {
    echo cp -a $static_dir $install_dir
    cp -a $static_dir $install_dir
}

copy_cygwin() {
    for binary in cygcrypto-0.9.8.dll cygwin1.dll cygssl-0.9.8.dll cygcurl-3.dll cygz.dll cygiconv-2.dll cygintl-3.dll tar.exe bzip2.exe gzip.exe; do
	cp /bin/$binary $install_dir/bin
    done
}

copy_gtk() {
    echo "copying gtk and its dependencies..."
    cp "$gtk_prefix"/bin/*.dll $install_dir/bin
    cp -r "$gtk_prefix"/etc $install_dir/etc
    (cd "$gtk_prefix" && cp --parents lib/pango/1.4.0/modules/* $install_dir/)
    (cd "$gtk_prefix" && cp -r --parents lib/locale/de $install_dir)
    (cd "$gtk_prefix" && cp -r --parents share/locale/de $install_dir)
    (cd "$gtk_prefix" && cp -r --parents share/locale/sv $install_dir)
    (cd "$gtk_prefix" && cp --parents lib/gtk-2.0/2.4.0/loaders/* $install_dir/)
}

copy_gtk_full() {
    echo "copying all of gtk and its dependencies..."
    cp -r "$gtk_prefix"/* $install_dir
}

force_openvas_language() {
    sed -e "s/ -DLANGUAGE=......//" < $openvas_dir/nessus/cflags \
        | sed -e "s/-DHAVE_GNU_GETTEXT/-DHAVE_GNU_GETTEXT -DLANGUAGE=\\\\\"$1\\\\\"/" \
        > $openvas_dir/nessus/cflags.tmp
    mv $openvas_dir/nessus/cflags.tmp $openvas_dir/nessus/cflags
    rm -f $openvas_dir/nessus/nessus.o
    (cd $openvas_dir && make)
}

copy_openvas() {
    echo "copying openvas"
    cp $openvas_dir/bin/* $install_dir/bin
    cp $openvas_dir/po/de.gmo $install_dir/share/locale/de/LC_MESSAGES/OpenVAS-Client.mo
    cp $openvas_dir/po/sv.gmo $install_dir/share/locale/sv/LC_MESSAGES/OpenVAS-Client.mo
}

force_sladinstaller_language() {
    grep -v LANGUAGE $sladinstaller_dir/Makefile.config > $sladinstaller_dir/Makefile.config.tmp
    mv $sladinstaller_dir/Makefile.config.tmp $sladinstaller_dir/Makefile.config
    echo 'CXXFLAGS+=-DLANGUAGE=\"'$1'\"' >> $sladinstaller_dir/Makefile.config
    rm -f $sladinstaller_dir/gtk.o
    (cd $sladinstaller_dir && make)
}
copy_sladinstaller() {
    echo "copying sladinstaller"
    cp $sladinstaller_dir/sladinstaller.exe $install_dir/bin
    cp $sladinstaller_dir/de.mo $install_dir/share/locale/de/LC_MESSAGES/sladinstaller.mo
}

run_innosetup() {
    lang=$1
    case $lang in
	de)
	  language='Name: "de"; MessagesFile: "compiler:Languages\\German.isl"'
	  manualname='OpenVAS-Client Handbuch'
	  manualfile='users-manual-de.pdf'
	  ;;

	sv)
	  language='Name: "sv"; MessagesFile: "compiler:Languages\\Swedish.isl"'
	  manualname='OpenVAS-Client Manual'
	  manualfile='users-manual.pdf'
	  ;;
	en)
	  language='Name: "en"; MessagesFile: "compiler:Default.isl"'
	  manualname='OpenVAS-Client Manual'
	  manualfile='users-manual.pdf'
	  ;;
    esac

    sed -e "s/@LANGUAGE@/$language/" \
	-e "s/@LANG@/$lang/" \
	-e "s/@MANUALNAME@/$manualname/" \
	-e "s/@MANUALFILE@/$manualfile/" \
	< openvasclient+gtk.iss.in \
	> openvasclient+gtk.iss

    $innosetup openvasclient+gtk.iss
}

init && copy_static && copy_cygwin && copy_gtk \
    && force_openvas_language en && copy_openvas && force_sladinstaller_language en && copy_sladinstaller && run_innosetup en \
    && force_openvas_language sv && copy_openvas && force_sladinstaller_language en && copy_sladinstaller && run_innosetup sv \
    && force_openvas_language de && copy_openvas && force_sladinstaller_language de && copy_sladinstaller && run_innosetup de
