//                                               -*- C++ -*-
/**
 *  @file  CovarianceHMatrix.hxx
 *  @brief This class builds a covariance model as an H-Matrix
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-04-18 17:56:46 +0200 (Wed, 18 Apr 2012)
 */
#ifndef OPENTURNS_COVARIANCEHMATRIX_HXX
#define OPENTURNS_COVARIANCEHMATRIX_HXX

#include "Object.hxx"
#include "CovarianceModel.hxx"
#include "Mesh.hxx"
#include "NumericalPoint.hxx"
#include "Pointer.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class CovarianceHMatrix
 */

class OT_API CovarianceHMatrix
  : public Object
{

  CLASSNAME;

public:

  /** Default constructor without parameters */
  CovarianceHMatrix();

  /* Parameters constructor */
  CovarianceHMatrix(const CovarianceModel & covarianceModel, const Mesh & mesh, NumericalScalar epsilon = 0.0);

  /** Dimension accessor */
  UnsignedInteger getDimension() const;

  /** String converter */
  String __repr__() const;

  /** String converter */
  String __str__(const String & offset = "") const;

  /** Return L*x */
  NumericalPoint gemvLower(const NumericalPoint & x);

private:
  void assembleAndComputeCholesky(const CovarianceModel & covarianceModel, const Mesh & mesh, NumericalScalar epsilon);

  UnsignedInteger dimension_;
  Bool isInitialized_;
  // Forward declaration
  struct MatImpl;
  Pointer<MatImpl> hmat_;

} ; /* class CovarianceHMatrix */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_COVARIANCEHMATRIX_HXX */
