"computeTestChiSquaredPoisson" <-
function(numericalSample, lambda, testLevel = 0.95, estimatedParameters) {

  # pTheoric : the theoretical values of p. 
  pTheoric <- dpois(0 : max(numericalSample), lambda)
  pTheoric <- c(pTheoric, 1 - sum(pTheoric))

  # Putting numericaSample in the correct form. 
  x <- c(hist(numericalSample, breaks = -1 : max(numericalSample), plot = FALSE)$count, 0)

  # This uses the chisq.test function from the R "stats" package.
  testChiSquared <- chisq.test(x, p = pTheoric)    
  
  testResult <- ifelse(testChiSquared$p.value > 1 - testLevel, 1, 0)
  return(list(test = "ChiSquaredPoisson",
              testResult = testResult,
              threshold = 1 - testLevel,
              pValue = testChiSquared$p.value))
}

