// SWIG file Graph.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: Graph.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "Graph.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Graph::Graph>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Graph::Graph
  convert<_PySequence_,OpenTURNS::Base::Graph::Graph>(PyObject * pyObj)
  {
    String title;
    String xTitle;
    String yTitle;
    Bool showAxes;
    String legendPosition = Base::Graph::GraphImplementation::NoSpecifiedLabel;
    NumericalScalar legendFontSize = Base::Graph::GraphImplementation::DefaultLegendFontSize;

    check<_PySequence_>( pyObj );
    switch (PySequence_Fast_GET_SIZE( pyObj )) {
     case 6: { PyObject * item_5 = PySequence_Fast_GET_ITEM( pyObj, 5 );
               check<_PyFloat_>( item_5 );
               legendFontSize = convert<_PyFloat_,NumericalScalar>( item_5 ); }
     case 5: { PyObject * item_4 = PySequence_Fast_GET_ITEM( pyObj, 4 );
               check<_PyString_>( item_4 );
               legendPosition = convert<_PyString_,String>( item_4 ); }
     case 4: { PyObject * item_0 = PySequence_Fast_GET_ITEM( pyObj, 0 );
               check<_PyString_>( item_0 );
               title = convert<_PyString_,String>( item_0 );
               PyObject * item_1 = PySequence_Fast_GET_ITEM( pyObj, 1 );
               check<_PyString_>( item_1 );
               xTitle = convert<_PyString_,String>( item_1 );
               PyObject * item_2 = PySequence_Fast_GET_ITEM( pyObj, 2 );
               check<_PyString_>( item_2 );
               yTitle = convert<_PyString_,String>( item_2 );
               PyObject * item_3 = PySequence_Fast_GET_ITEM( pyObj, 3 );
               check<_PyBool_>( item_3 );
               showAxes = convert<_PyBool_,Bool>( item_3 ); }
             break;
     default:
      throw Base::Common::InvalidArgumentException(HERE) << "Sequence passed as argument is not convertible to a Graph. Expected sequence (String, String, String, Bool, String, NumericalScalar)";
    }
    return OpenTURNS::Base::Graph::Graph( title, xTitle, yTitle, showAxes, legendPosition, legendFontSize);
  }


} /* namespace OpenTURNS */

%}

%template(GraphImplementationTypedInterfaceObject) OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Graph::GraphImplementation>;

%template(GraphCollection) OpenTURNS::Base::Type::Collection<OpenTURNS::Base::Graph::Graph>;

%include Graph.hxx

namespace OpenTURNS{ namespace Base { namespace Graph {

%extend Graph {

Graph(const Graph & other) { return new OpenTURNS::Base::Graph::Graph(other); }

Graph(PyObject * pyObj)
{
 return new OpenTURNS::Base::Graph::Graph( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Graph::Graph>(pyObj) );
}

}

}}}
