//                                               -*- C++ -*-
/**
 *  @file  t_LaguerreFactory_std.cxx
 *  @brief The test file of class LaguerreFactory for standard methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (mer, 21 mai 2008) $
 *  Id:      $Id: t_LaguerreFactory_std.cxx 818 2008-05-21 15:44:02Z dutka $
 */
#include <iostream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalPoint.hxx"
#include "LaguerreFactory.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    LaguerreFactory laguerre(2.5);
    fullprint << "laguerre=" << laguerre << std::endl;
    for (UnsignedLong i = 0; i < 10; ++i)
      {
	fullprint << "laguerre(" << i << ")=" << laguerre.build(i).__str__() << std::endl;
      }
    NumericalPoint roots(laguerre.getRoots(10));
    fullprint << "laguerre(10) roots=" << roots << std::endl;
    NumericalPoint weights;
    roots = laguerre.getNodesAndWeights(10, weights);
    fullprint << "laguerre(10) roots=" << roots << " and weights=" << weights << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
