//                                               -*- C++ -*-
/**
 *  @file  NormalFactory.hxx
 *  @brief Factory for Normal distribution
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NormalFactory.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_NORMALFACTORY_HXX
#define OPENTURNS_NORMALFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class NormalFactory
       */
      class NormalFactory
	: public Model::DistributionImplementationFactory
      {
      public:

	typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
	typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
	typedef DistributionImplementationFactory::InternalException        InternalException;
	typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;
	typedef Model::DistributionImplementation                           DistributionImplementation;

	/** Default constructor */
	NormalFactory();

	/** Virtual constructor */
	virtual NormalFactory * clone() const;

	/* Here is the interface that all derived class must implement */

	DistributionImplementation * buildImplementation(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;
	DistributionImplementation * buildImplementation(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
	DistributionImplementation * buildImplementation() const /* throw(InvalidArgumentException, InternalException) */;

    
      }; /* class NormalFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NORMALFACTORY_HXX */
