//                                               -*- C++ -*-
/**
 *  @file  StandardDistributionPolynomialFactory.cxx
 *  @brief OrthogonalUniVariatePolynomialStandardDistribution polynomial factory
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */

#include "StandardDistributionPolynomialFactory.hxx"
#include "PersistentObjectFactory.hxx"
#include "Uniform.hxx"
#include "GramSchmidtAlgorithm.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(StandardDistributionPolynomialFactory);

      static Base::Common::Factory<StandardDistributionPolynomialFactory> RegisteredFactory("StandardDistributionPolynomialFactory");

      typedef Distribution::Uniform Uniform;

      /* Default constructor */
      StandardDistributionPolynomialFactory::StandardDistributionPolynomialFactory()
        : OrthogonalUniVariatePolynomialFactory(Uniform()),
          orthonormalizationAlgorithm_(GramSchmidtAlgorithm(Uniform()))
      {
        // Initialize the coefficient cache
        initializeCache();
      }


      /* Parameter constructor */
      StandardDistributionPolynomialFactory::StandardDistributionPolynomialFactory(const Distribution & measure)
        : OrthogonalUniVariatePolynomialFactory(measure),
          orthonormalizationAlgorithm_(GramSchmidtAlgorithm(measure))
      {
        initializeCache();
      }


      /* Parameter constructor */
      StandardDistributionPolynomialFactory::StandardDistributionPolynomialFactory(const OrthonormalizationAlgorithm & orthonormalizationAlgorithm)
        : OrthogonalUniVariatePolynomialFactory(orthonormalizationAlgorithm.getMeasure()),
          orthonormalizationAlgorithm_(orthonormalizationAlgorithm)
      {
        initializeCache();
      }


      /* Virtual constructor */
      StandardDistributionPolynomialFactory * StandardDistributionPolynomialFactory::clone() const
      {
        return new StandardDistributionPolynomialFactory(*this);
      }


      /* Calculate the coefficients of recurrence a0n, a1n, a2n such that
         Pn+1(x) = (a0n * x + a1n) * Pn(x) + a2n * Pn-1(x) */
      StandardDistributionPolynomialFactory::Coefficients StandardDistributionPolynomialFactory::getRecurrenceCoefficients(const UnsignedLong n) const
      {
        return orthonormalizationAlgorithm_.getRecurrenceCoefficients(n);
      }

      /* String converter */
      String StandardDistributionPolynomialFactory::__repr__() const
      {
        return OSS() << "class=" << getClassName()
                     << " orthonormalization algorithm=" << orthonormalizationAlgorithm_;
      }


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
