//                                               -*- C++ -*-
/**
 *  @file  OrthogonalUniVariatePolynomialFamily.hxx
 *  @brief This is the interface class for orthogonal polynomial factories
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFAMILY_HXX
#define OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFAMILY_HXX

#include "TypedInterfaceObject.hxx"
#include "OrthogonalUniVariatePolynomialFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthogonalUniVariatePolynomialFamily
       *
       * This is the interface class for orthogonal polynomial factories
       */

      class OrthogonalUniVariatePolynomialFamily
        : public Base::Common::TypedInterfaceObject<OrthogonalUniVariatePolynomialFactory>
      {
        CLASSNAME;
      public:

        typedef Base::Common::StorageManager                                          StorageManager;
        typedef OrthogonalUniVariatePolynomialFactory::Distribution                   Distribution;
        typedef OrthogonalUniVariatePolynomialFactory::Coefficients                   Coefficients;
        typedef OrthogonalUniVariatePolynomialFactory::NumericalPoint                 NumericalPoint;

        /** Default constructor */
        OrthogonalUniVariatePolynomialFamily();

        /** Constructor from implementation */
        OrthogonalUniVariatePolynomialFamily(const OrthogonalUniVariatePolynomialFactory & implementation);

        /** String converter */
        virtual String __repr__() const;

        /** The method to get the polynomial of any degree. */
        OrthogonalUniVariatePolynomial build(const UnsignedLong degree) const;

        /** Roots of the polynomial of degree n as the eigenvalues of the associated matrix */
        NumericalPoint getRoots(const UnsignedLong n) const;

        /** Nodes and weights of the polynomial of degree n as the eigenvalues of the associated matrix, to build quadrature rules */
        NumericalPoint getNodesAndWeights(const UnsignedLong n,
                                          NumericalPoint & weights) const;

        /** Measure accessor */
        Distribution getMeasure() const;

        /** Calculate the coefficients of recurrence a0, a1, a2 such that
            Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
        Coefficients getRecurrenceCoefficients(const UnsignedLong n) const;

      protected:

      private:

      } ; /* class OrthogonalUniVariatePolynomialFamily */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFAMILY_HXX */
