//                                               -*- C++ -*-
/**
 *  @file  FunctionalChaosResult.hxx
 *  @brief The result of a chaos expansion
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_FUNCTIONALCHAOSRESULT_HXX
#define OPENTURNS_FUNCTIONALCHAOSRESULT_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "Indices.hxx"
#include "Collection.hxx"
#include "NumericalMathFunction.hxx"
#include "Distribution.hxx"
#include "OrthogonalBasis.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class FunctionalChaosResult
       *
       * The result of a chaos expansion
       */

      class FunctionalChaosResult
	: public Base::Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Base::Common::StorageManager                  StorageManager;
	typedef Base::Type::Indices                           Indices;
	typedef Base::Type::NumericalPoint                    NumericalPoint;
	typedef Base::Func::NumericalMathFunction             NumericalMathFunction;
	typedef Base::Type::Collection<NumericalMathFunction> NumericalMathFunctionCollection;
	typedef Model::Distribution                           Distribution;

 	// friend class Base::Common::Factory<FunctionalChaosResult>;

	/** Default constructor */
	FunctionalChaosResult();

	/** Parameter constructor */
	FunctionalChaosResult(const NumericalMathFunction & model,
			      const Distribution & distribution,
			      const NumericalMathFunction & transformation,
			      const NumericalMathFunction & inverseTransformation,
			      const NumericalMathFunction & composedModel,
			      const OrthogonalBasis & orthogonalBasis,
			      const Indices & I,
			      const NumericalPoint & alpha_k,
			      const NumericalMathFunctionCollection & Psi_k,
			      const NumericalScalar residual);

	/** Virtual constructor */
	virtual FunctionalChaosResult * clone() const;

	/** String converter */
	virtual String __repr__() const;

	/** Model accessor */
	virtual NumericalMathFunction getModel() const;

	/** Distribution accessor */
	virtual Distribution getDistribution() const;

	/** IsoProbabilisticTransformation accessor */
	virtual NumericalMathFunction getTransformation() const;

	/** InverseIsoProbabilisticTransformation accessor */
	virtual NumericalMathFunction getInverseTransformation() const;

	/** Composed model accessor */
	virtual NumericalMathFunction getComposedModel() const;

	/** Orthogonal basis accessor */
	virtual OrthogonalBasis getOrthogonalBasis() const;

	/** Indices accessor */
	virtual Indices getIndices() const;

	/** Coefficients accessor */
	virtual NumericalPoint getCoefficients() const;

	/** Reduced basis accessor */
	virtual NumericalMathFunctionCollection getReducedBasis() const;

	/** Residual accessor */
	virtual NumericalScalar getResidual() const;

	/** MetaModel accessor */
	virtual NumericalMathFunction getMetaModel() const;

	/** Method save() stores the object through the StorageManager */
	virtual void save(StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(StorageManager::Advocate & adv);


      protected:

      private:
	/** The function to model */
	NumericalMathFunction model_;

	/** The input vector distribution */
	Distribution distribution_;

	/** The isoprobabilistic transformation maps the distribution into the orthogonal measure */
	NumericalMathFunction transformation_;

	/** The inverse isoprobabilistic transformation */
	NumericalMathFunction inverseTransformation_;

	/** The composed model */
	NumericalMathFunction composedModel_;

	/** The orthogonal basis */
	OrthogonalBasis orthogonalBasis_;

	/** The collection of indices */
	Indices I_;

	/** The collection of Alpha_k coefficients */
	NumericalPoint alpha_k_;

	/** The collection of vectors upon which we project the (composed) model */
	NumericalMathFunctionCollection Psi_k_;

	/** Residual */
	NumericalScalar residual_;

	/** Meta model */
	NumericalMathFunction metaModel_;

      } ; /* class FunctionalChaosResult */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_FUNCTIONALCHAOSRESULT_HXX */
