//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionHessian.hxx
 *  @brief Class for the InverseNataf transformation hessian for elliptical
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: InverseNatafEllipticalDistributionHessian.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONHESSIAN_HXX
#define OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONHESSIAN_HXX

#include "OTprivate.hxx"
#include "ConstantNumericalMathHessianImplementation.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class InverseNatafEllipticalDistributionHessian
       *
       * This class offers an interface for the InverseNataf gradient for elliptical distributions
       */
      class InverseNatafEllipticalDistributionHessian
	: public Base::Func::ConstantNumericalMathHessianImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::ConstantNumericalMathHessianImplementation ConstantNumericalMathHessianImplementation;

	/** Parameter constructor */
	InverseNatafEllipticalDistributionHessian(const UnsignedLong dimension);


	/** String converter */
	virtual String __repr__() const;

      protected:

    
      private:

      }; /* InverseNatafEllipticalDistributionHessian */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONHESSIAN_HXX */
