//                                               -*- C++ -*-
/**
 *  @file  BootstrapExperiment.hxx
 *  @brief Abstract top-level view of an bootstrapExperiment plane
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: BootstrapExperiment.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_BOOTSTRAPEXPERIMENT_HXX
#define OPENTURNS_BOOTSTRAPEXPERIMENT_HXX

#include "WeightedExperiment.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class BootstrapExperiment
       *
       * The class describes the probabilistic concept of bootstrapExperiment plan
       */
      class BootstrapExperiment
        : public WeightedExperiment
      {
        CLASSNAME;
      public:

        typedef WeightedExperiment::Distribution Distribution;

        /** Default constructor */
        explicit BootstrapExperiment(const String & name = OT::DefaultName);

        /** Parameters constructor */
        explicit BootstrapExperiment(const NumericalSample & sample,
                                     const String & name = OT::DefaultName);

        /** Virtual constructor */
        virtual BootstrapExperiment * clone() const;

        /** String converter */
        virtual String __repr__() const;

        /* Here is the interface that all derived class must implement */

        /** Sample generation */
        virtual NumericalSample generate();

        /** Sample generation with weights */
        virtual NumericalSample generate(NumericalPoint & weights);

      protected:

      private:

      }; /* class BootstrapExperiment */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BOOTSTRAPEXPERIMENT_HXX */
