//                                               -*- C++ -*-
/**
 *  @file  Library.hxx
 *  @brief A Library object points to an actual shared library
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Library.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_LIBRARY_HXX
#define OPENTURNS_LIBRARY_HXX

#include <iostream>              // for std::ostream
#include "OTprivate.hxx"
#include "PersistentObject.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class Library
       * @brief Points to an actual shared library
       * @ingroup Wrapper
       *
       * Library defines an abstraction of a shared library.
       * It stores a handle onto the actual opened library and
       * gives access to its symbols.
       */

      class Library
	: public Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Common::DynamicLibraryException DynamicLibraryException;

	friend class LibraryLoader;

	/* Virtual constructor */
	virtual Library * clone() const;

	/* Comparison operator */
	Bool operator ==(const Library & other) const;

	/* String converter */
	virtual String __repr__() const;

	/** @brief Library symbol accessor
	 * This method retrieves the symbol stored in the dynamic library and casts it to make it usable afterwards.
	 * If the symbol wasn't found a DynamicLibraryException is raised indicating the failure.
	 * @throw DynamicLibraryException
	 * @param symbolName The name of the symbol to look for
	 * @result A symbol usable by other Open TURNS objects
	 */
	LibrarySymbol getSymbol(String symbolName) const
	  /* throw(DynamicLibraryException) */;

      protected:

      private:

	/** The handle to the actual shared library */
	const LibraryHandle handle_;

	/** The path of the library */
	String path_;

	/** 
	 * Default constructor
	 */
	Library(LibraryHandle handle, const String & path);

      }

      ; /* class Library */



    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LIBRARY_HXX */
