//                                               -*- C++ -*-
/**
 *  @file  ComposedNumericalMathGradientImplementation.hxx
 *  @brief The class that implements the composition between numerical math functions
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: ComposedNumericalMathGradientImplementation.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_COMPOSEDNUMERICALMATHGRADIENTIMPLEMENTATION_HXX
#define OPENTURNS_COMPOSEDNUMERICALMATHGRADIENTIMPLEMENTATION_HXX

#include "NumericalMathGradientImplementation.hxx"
#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class ComposedNumericalMathGradientImplementation
       *
       * The class that implement the composition of two numerical math functions,
       * its gradient and its hessian. This class has no implementation class
       */
      class ComposedNumericalMathGradientImplementation 
	: public NumericalMathGradientImplementation
      {
	CLASSNAME;
      public:

	/* Some typedefs for easy reading */
	typedef NumericalMathGradientImplementation::NumericalPoint            NumericalPoint;
	typedef NumericalMathGradientImplementation::Matrix                    Matrix;
	typedef Common::Pointer<NumericalMathEvaluationImplementation>         EvaluationImplementation;
	typedef Common::Pointer<NumericalMathGradientImplementation>           GradientImplementation;
	typedef NumericalMathGradientImplementation::InvalidArgumentException  InvalidArgumentException;
	typedef NumericalMathGradientImplementation::InternalException         InternalException;
	typedef NumericalMathGradientImplementation::StorageManager            StorageManager;

	/** Default constructor */
	ComposedNumericalMathGradientImplementation(const GradientImplementation & p_leftGradient,
                                                    const EvaluationImplementation & p_rightFunction,
                                                    const GradientImplementation & p_rightGradient) /* throw(InvalidArgumentException) */;


	/** Virtual constructor */
	virtual ComposedNumericalMathGradientImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const ComposedNumericalMathGradientImplementation & other) const;

	/** String converter */
	virtual String __repr__() const;

	/** Method gradient() returns the Jacobian transposed matrix of the function at point */
	Matrix gradient(const NumericalPoint & in) const
	  /* throw(InvalidArgumentException,InternalException) */;

	/** Accessor for input point dimension */
	UnsignedLong getInputDimension() const
	  /* throw(InternalException) */;

	/** Accessor for output point dimension */
	UnsignedLong getOutputDimension() const
	  /* throw(InternalException) */;

 	/** Method save() stores the object through the StorageManager */
	void save(StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(StorageManager::Advocate & adv);

      protected:

	ComposedNumericalMathGradientImplementation() {};
	friend class Common::Factory<ComposedNumericalMathGradientImplementation>;
    
      private:

	/** The gradient of f in h = f o g */
	GradientImplementation p_leftGradient_;

	/** The function g in h = f o g */
	EvaluationImplementation p_rightFunction_;

	/** The gradient of g in h = f o g */
	GradientImplementation p_rightGradient_;

      }; /* class ComposedNumericalMathGradientImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPOSEDNUMERICALMATHGRADIENTIMPLEMENTATION_HXX */
