//                                               -*- C++ -*-
/**
 *  @file  IdFactory.hxx
 *  @brief The class IdFactory builds unique Ids for all Objects
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: IdFactory.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_IDFACTORY_HXX
#define OPENTURNS_IDFACTORY_HXX

#include <iostream>              // for std::ostream
#include "OTprivate.hxx"
#include "OStream.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class IdFactory
       *
       * @brief %IdFactory builds unique Ids for all PersistentObjects
       * @see PersistentObject
       * @see StorageManager
       *
       * The IdFactory ensures that each PersistentObject has an unique Id so they can be 
       * distinguished from each other.
       * The IdFactory implements a 'singleton' strategy.
       */

      class IdFactory
      {

      public:

	/** The accessor to the Singleton element */
	static IdFactory & getInstance();
	
	/** The cleanup method that frees all previously allocated storage */
	static void Release();

	  
	/** @copydoc Object::__repr__() const */
	String __repr__() const;

	/** Id accessor
	 *
	 * The way to get an Id for a new PersistentObject.
	 */
	Id buildId();


      protected:

      private:

	/** The unique instance of the Singleton model */
	static IdFactory * p_instance_;

	/** The next Id to produce */
	Id nextId_;

	/** Default constructor */
	IdFactory();



      }

      ; /* class IdFactory */

      /**
       * @fn std::ostream & operator <<(std::ostream & os, const IdFactory & obj)
       * @brief Output stream converter
       * @param os A STL output stream object
       * @param obj The object read by \em os
       * @return A reference to \em os
       */
      std::ostream & operator <<(std::ostream & os, const IdFactory & obj);
#ifndef SWIG
      OStream & operator <<(OStream & OS, const IdFactory & obj);
#endif

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_IDFACTORY_HXX */
