//                                               -*- C++ -*-
/**
 *  @file  Catalog.cxx
 *  @brief Catalog records all user information to a file or tty
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Catalog.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <iostream>
#include <cstdlib>
#include <assert.h>
#include <errno.h>
#include "OSS.hxx"
#include "Catalog.hxx"
#include "Exception.hxx"
#include "Log.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /* Initialize the instance */
      Catalog * Catalog::P_instance_ = 0;



      /* Constructor */
      Catalog::Catalog()
	: catalog_()
      {
	// Registration of destructor at exit
	std::atexit(Catalog::Release);
      }


      /* Destructor */
      Catalog::~Catalog()
      {
	CatalogType::iterator it;
	for(it = catalog_.begin(); it != catalog_.end(); ++it) {
	  delete it->second;
	}
      }


      /* Return the catalog as a singleton */
      Catalog & Catalog::GetInstance()
      {
	if (!P_instance_) P_instance_ = new Catalog;
	return *P_instance_;
      }



      void Catalog::Release()
      {
	delete P_instance_;
	P_instance_ = 0;
      }


      /* Get the factory from its name */
      const PersistentObjectFactory & Catalog::get(const String & factoryName) const
      {
	CatalogType::const_iterator it = catalog_.find(factoryName);
	if (it == catalog_.end())
	  throw InvalidArgumentException(HERE) << "No factory named '" << factoryName << "' in catalog";

	return *(it->second);
      }


      /* Add a new factory to the catalog */
      void Catalog::add(const String & factoryName, const PersistentObjectFactory * p_factory)
      {
	if (catalog_.find(factoryName) == catalog_.end()) {
	  catalog_[factoryName] = p_factory->clone();
	  // Log::Debug(OSS() << "Adding factory of " << factoryName << " to Catalog");
	}
      }


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
