#                                               -*- Autoconf -*-
#
#  ot_check_bc.m4
#
#  (C) Copyright 2005-2010 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
#  Id:      $Id: ot_check_bc.m4 1473 2010-02-04 15:44:49Z dutka $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether Bc is available on the
#  build platform.
#
# OT_CHECK_BC
# -----------
#
AC_DEFUN([OT_CHECK_BC],
[
  WITH_BC=0
  AC_ARG_VAR([BC], [path for bc tool])
  AC_PATH_PROG([BC], [bc])
  test x$BC = x || WITH_BC=1

  # Propagate test into atlocal
  AC_SUBST(WITH_BC)

  # Propagate test into Makefiles
  AM_CONDITIONAL(WITH_BC, test $WITH_BC = 1)

  # Propagate bc into source files
  AC_DEFINE_UNQUOTED([BC_EXECUTABLE_NAME], "${BC}", [The name of the bc executable])
])
