#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

class FUNC(OpenTURNSPythonFunction):

  def __init__(self):
    OpenTURNSPythonFunction.__init__(self, 2, 1)

  def f(self, X):
    print X
    Y = [0]
    Y[0] = X[0] + X[1]
    print Y
    return Y

F=FUNC()
print F.getInputNumericalPointDimension(), F.getOutputNumericalPointDimension()

print F( (10,5) )


try :

  #Instance creation
  myFunc = NumericalMathFunction( F )

  #Copy constructor
  newFunc = NumericalMathFunction(myFunc)

  print "myFunc input dimension=", myFunc.getInputNumericalPointDimension()
  print "myFunc output dimension=", myFunc.getOutputNumericalPointDimension()

  inPt = NumericalPoint(2, 2.)
  print repr(inPt)

  outPt = myFunc ( inPt )
  print repr(outPt)

  
except :
  import sys
  print "t_NumericalMathFunction_python.py", sys.exc_type, sys.exc_value
