#                                               -*- Python -*-
#
#  __init__.py
#
#  (C) Copyright 2005-2009 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: dutka $
#  @date:   $LastChangedDate: 2009-01-28 14:45:54 +0100 (mer, 28 jan 2009) $
#  Id:      $Id: Makefile.am 1087 2009-01-28 13:45:54Z dutka $
#
import openturns_preload
from common import *
from wrapper import *
from base_all import *
from uncertainty_all import *

import os
import sys

# This code prints the version number when the module is imported
if not ( ( os.environ.has_key( 'OPENTURNS_PYTHON_SILENT' ) and ( len(os.environ[ 'OPENTURNS_PYTHON_SILENT' ]) != 0 ) ) or ( "--silent" in sys.argv ) ):
  sys.stderr.write( "Welcome to OpenTURNS version %s\n" % PlatformInfo.GetVersion() )

# This code sets the sys.path (through site module) to point to the module standard dirs
dirs = os.getenv("OPENTURNS_MODULE_PATH", None)
if dirs:
    import string
    dirlist = string.split(dirs, ":")
else:
    dirlist = list()
dirlist.append( "%s/openturns/lib/openturns/module" % os.getenv("HOME") )
dirlist.append( PlatformInfo.GetModuleDirectory() )
dirlist.append( PlatformInfo.GetInstallationDirectory() )

import site
for d in dirlist:
    site.addsitedir( d + "/lib/python%d.%d/site-packages" % ( sys.version_info[0], sys.version_info[1] ) )

def PRINT(obj):
  return repr(obj)
