// SWIG file BoundConstrainedAlgorithmImplementation.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
// Id : $Id: BoundConstrainedAlgorithmImplementation.i 1262 2009-05-28 12:47:53Z dutka $

%{
#include "BoundConstrainedAlgorithmImplementation.hxx"
%}

%include BoundConstrainedAlgorithmImplementation.hxx

namespace OpenTURNS { namespace Base { namespace Optim {
/*
 * Result stores the optimization result 
 */
class BoundConstrainedAlgorithmImplementationResult: public
 OpenTURNS::Base::Common::PersistentObject
{
public:
		
  /* Default constructor */
  explicit BoundConstrainedAlgorithmImplementationResult();

  /* Standard constructor */
  BoundConstrainedAlgorithmImplementationResult(const Type::NumericalPoint & optimizer,
         const NumericalScalar optimalValue,
	 const BoundConstrainedAlgorithmImplementation::OptimizationProblem optimization,
	 const UnsignedLong evaluationsNumber,
	 const NumericalScalar absoluteError,
	 const NumericalScalar relativeError,
	 const NumericalScalar objectiveError,
	 const NumericalScalar constraintError);


  /* Copy constructor */
  BoundConstrainedAlgorithmImplementationResult(const BoundConstrainedAlgorithmImplementationResult & other);

  /* Virtual constructor */
  virtual BoundConstrainedAlgorithmImplementationResult * clone() const;

  /* Destructor */
  virtual ~BoundConstrainedAlgorithmImplementationResult();

  /* Optimizer accessors */
  Type::NumericalPoint getOptimizer() const;

  /* Optimal value accessor */
  NumericalScalar getOptimalValue() const;

  /* Optimization problem accessor */
  BoundConstrainedAlgorithmImplementation::OptimizationProblem getOptimizationProblem() const;

  /* Iterations number accessor */
  UnsignedLong getEvaluationsNumber() const;

  /* Absolute error accessor */
  NumericalScalar getAbsoluteError() const;

  /* Relative error accessor */
  NumericalScalar getRelativeError() const;

  /* Objective error accessor */
  NumericalScalar getObjectiveError() const;

  /* Constraint error accessor */
  NumericalScalar getConstraintError() const;

  /* String converter */
  String __repr__() const;

}; // class BoundConstrainedAlgorithmImplementationResult

%extend BoundConstrainedAlgorithmImplementationResult {
  const String __str__() const { return self->__repr__(); }
}

}}}

namespace OpenTURNS{ namespace Base { namespace Optim { %extend BoundConstrainedAlgorithmImplementation { BoundConstrainedAlgorithmImplementation(const BoundConstrainedAlgorithmImplementation & other) { return new OpenTURNS::Base::Optim::BoundConstrainedAlgorithmImplementation(other); } } }}}
