//                                               -*- C++ -*-
/**
 *  @file  t_NumericalSample_large.cxx
 *  @brief The test file of class NumericalSample of big size
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_NumericalSample_large.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

#ifdef DEBUG_MEMORY
      std::cerr << "Memory usage std=" << GetMemoryUsage() << " full=" << GetFullMemoryUsage() << std::endl;
#endif

    {
      // We create an empty NumericalSample
      NumericalSample sample(0, 2);
      sample.setName("EmptySample");
      fullprint << "sample=" << sample << std::endl;

      try {
	// We access the element of the sample
	NumericalPoint p(sample[0]);
	fullprint << "p=" << p << std::endl;

	// We should NEVER go here
	throw TestFailed("Exception NOT thrown");
      }
      catch (OutOfBoundException & ex) {
	// Nothing to do
      }
    }

#ifdef DEBUG_MEMORY
      std::cerr << "Memory usage std=" << GetMemoryUsage() << " full=" << GetFullMemoryUsage() << std::endl;
#endif

    {
      // We create an small NumericalSample
      NumericalSample sample(1, 2);
      sample.setName("SmallSample");
      fullprint << "sample=" << sample << std::endl;

      // We access the element of the sample
      NumericalPoint p(sample[0]);
      fullprint << "p=" << p << std::endl;
      try {
	// We try to access past the last element of the point
	fullprint << "p[0]=" << p[0] 
		  << " p[1]=" << p[1]
		  << " p[2]=" << p[2]
		  << std::endl;

	// We should NEVER go here
	throw TestFailed("Exception NOT thrown");
      }
      catch (OutOfBoundException & ex) {
	// Nothing to do
      }
    }

#ifdef DEBUG_MEMORY
      std::cerr << "Memory usage std=" << GetMemoryUsage() << " full=" << GetFullMemoryUsage() << std::endl;
#endif

    {
      // We create a big NumericalSample
      NumericalSample sample(1000000, 2);
      sample.setName("BigSample");

#ifdef DEBUG_MEMORY
      std::cerr << "Memory usage std=" << GetMemoryUsage() << " full=" << GetFullMemoryUsage() << std::endl;
      printMemoryUsage();
#endif

      // We populate the sample
      UnsignedLong size(sample.getSize());
      for(UnsignedLong i=0; i<size; i++) {
	sample[i] = NumericalPoint(2, i);
      }

      fullprint << "sample first point=" << sample[0]      << std::endl;
      fullprint << "sample last  point=" << sample[size-1] << std::endl;

#ifdef DEBUG_MEMORY
      std::cerr << "Memory usage std=" << GetMemoryUsage() << " full=" << GetFullMemoryUsage() << std::endl;
#endif
    }

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}

