//                                               -*- C++ -*-
/**
 *  @file  Event.cxx
 *  @brief The class that implements all random vectors
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Event.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "Event.hxx"


namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(Event);

      /* Constructor from RandomVector */
      Event::Event(const RandomVector & antecedent,
		   const ComparisonOperator & op,
		   const NumericalScalar threshold,
		   const String & name)
	throw (InvalidArgumentException)
	: RandomVector(antecedent, op, threshold, name)
      {
	// Nothing to do
      }

      /* String converter */
      String Event::__repr__() const {
	OSS oss;
	oss << "class=" << Event::GetClassName()
	    << " name=" << getName()
	    << " implementation=" << getImplementation()->__repr__();
	return oss;
      }
  
    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
