//                                               -*- C++ -*-
/**
 *  @file  SamplingStrategy.cxx
 *  @brief 
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: SamplingStrategy.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "SamplingStrategy.hxx"
#include "RandomDirection.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class SamplingStrategy
       */

      CLASSNAMEINIT(SamplingStrategy);

      /* Defaultonstructor */
      SamplingStrategy::SamplingStrategy()
	: Base::Common::TypedInterfaceObject<SamplingStrategyImplementation>(RandomDirection().clone())
      {
	// Nothing to do
      }

      /* Constructor with parameters */
      SamplingStrategy::SamplingStrategy(Implementation & p_implementation)
	: Base::Common::TypedInterfaceObject<SamplingStrategyImplementation>(p_implementation)
      {
	// Nothing to do
      }

      /* Constructor with parameters */
      SamplingStrategy::SamplingStrategy(const SamplingStrategyImplementation & implementation)
	: Base::Common::TypedInterfaceObject<SamplingStrategyImplementation>(implementation.clone())
      {
	// Nothing to do
      }

      /* Constructor with parameters */
      SamplingStrategy::SamplingStrategy(const UnsignedLong dimension)
	: Base::Common::TypedInterfaceObject<SamplingStrategyImplementation>(new RandomDirection(dimension))
      {
	// Nothing to do
      }

      /* Generate a set of directions */
      SamplingStrategy::NumericalSample SamplingStrategy::generate() const
      {
	return getImplementation()->generate();
      }

      /* Dimension accessor */
      void SamplingStrategy::setDimension(const UnsignedLong dimension)
      {
	getImplementation()->setDimension(dimension);
      }

      UnsignedLong SamplingStrategy::getDimension() const
      {
	return getImplementation()->getDimension();
      }

      /* String converter */
      String SamplingStrategy::__repr__() const
      {
	OSS oss;
	oss << "class=" << SamplingStrategy::GetClassName()
	    << " implementation=" << getImplementation()->__repr__();
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
