//                                               -*- C++ -*-
/**
 *  @file  OrthogonalUniVariatePolynomialFamily.hxx
 *  @brief This is the interface class for orthogonal polynomial factories
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFAMILY_HXX
#define OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFAMILY_HXX

#include "TypedInterfaceObject.hxx"
#include "OrthogonalUniVariatePolynomialFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthogonalUniVariatePolynomialFamily
       *
       * This is the interface class for orthogonal polynomial factories
       */

      class OrthogonalUniVariatePolynomialFamily
	: public Base::Common::TypedInterfaceObject<OrthogonalUniVariatePolynomialFactory>
      {
	CLASSNAME;
      public:

	typedef Base::Common::StorageManager                                StorageManager;
	typedef OrthogonalUniVariatePolynomialFactory::UniVariatePolynomial UniVariatePolynomial;
	typedef OrthogonalUniVariatePolynomialFactory::Distribution         Distribution;

	/** Default constructor */
	OrthogonalUniVariatePolynomialFamily();

	/** Constructor from implementation */
	OrthogonalUniVariatePolynomialFamily(const OrthogonalUniVariatePolynomialFactory & implementation);

	/** String converter */
	virtual String __repr__() const;

	/** The method to get the polynomial of any degree. */
	UniVariatePolynomial build(const UnsignedLong degree) const;

	/** Measure accessor */
	Distribution getMeasure() const;

      protected:

      private:

      } ; /* class OrthogonalUniVariatePolynomialFamily */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFAMILY_HXX */
