//                                               -*- C++ -*-
/**
 *  @file  OrthogonalUniVariatePolynomialFactory.hxx
 *  @brief This an abstract class for 1D polynomial factories
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFACTORY_HXX
#define OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFACTORY_HXX

#include <map>
#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "UniVariatePolynomial.hxx"
#include "Distribution.hxx"



namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthogonalUniVariatePolynomialFactory
       *
       * This an abstract class for 1D polynomial factories
       */

      class OrthogonalUniVariatePolynomialFactory
	: public Base::Common::PersistentObject
      {
	CLASSNAME;

      public:

	typedef Base::Common::StorageManager         StorageManager;
	typedef Base::Type::NumericalPoint           NumericalPoint;
	typedef Model::Distribution                  Distribution;
	typedef Base::Func::UniVariatePolynomial     UniVariatePolynomial;
	typedef UniVariatePolynomial::Coefficients   Coefficients;
	typedef std::map<UnsignedLong, Coefficients> CoefficientCache;
	

	/** Constructor */
	OrthogonalUniVariatePolynomialFactory(const Distribution & measure);

	/** Virtual constructor */
	virtual OrthogonalUniVariatePolynomialFactory * clone() const;

	/** String converter */
	virtual String __repr__() const;

	/** The method to get the polynomial of any degree. */
	UniVariatePolynomial build(const UnsignedLong degree) const;

	/** Root of the polynomial of degree n as the eigenvalues of the associated matrix */
	virtual NumericalPoint getRoots(const UnsignedLong n) const;

	/** Measure accessor */
	Distribution getMeasure() const;

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);


      protected:

	friend class Base::Common::Factory<OrthogonalUniVariatePolynomialFactory>;

	/** Default constructor */
	OrthogonalUniVariatePolynomialFactory();
	
	/** Determine the coefficients of the first orthogonal Polynomial (degree = 0) of the family */
	virtual Coefficients getP0Coefficients() const;	

	/** Determine the coefficients of the second orthogonal Polynomial (degree = 1) of the family */
	virtual Coefficients getP1Coefficients() const;	

	/** Calculate the coefficients of recurrence a0, a1, a2, a3 such that
            Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
	virtual Coefficients getRecurrenceCoefficients(const UnsignedLong n) const;

	/** Polynomial recurrence build the new coefficients of the polynomial Pn according to the relation
	    Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
	virtual Coefficients buildNewCoefficients(const Coefficients & Pn_minus_1_Coefficients,
						  const Coefficients & Pn_minus_2_Coefficients) const;
        
	/** Cache initialization */
	virtual void initializeCache();
        
	/** The distribution of the particular Orthonormal polynomial */
	Distribution measure_;

      private:

	/** A cache to save already computed coefficients */
	mutable CoefficientCache cache_;


      } ; /* class OrthogonalUniVariatePolynomialFactory */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHOGONALUNIVARIATEPOLYNOMIALFACTORY_HXX */
