//                                               -*- C++ -*-
/**
 *  @file  OrthogonalFunctionFactory.hxx
 *  @brief This is an abstract class for orthogonal basis
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_ORTHOGONALFUNCTIONFACTORY_HXX
#define OPENTURNS_ORTHOGONALFUNCTIONFACTORY_HXX

#include "PersistentObject.hxx"
#include "NumericalMathFunction.hxx"
#include "Distribution.hxx"
#include "EnumerateFunction.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthogonalFunctionFactory
       *
       * This is an abstract class for orthogonal basis
       */

      class OrthogonalFunctionFactory
	: public Base::Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathFunction NumericalMathFunction;
	typedef Model::Distribution               Distribution;

	/** Default constructor */
	OrthogonalFunctionFactory();

	/** Build the NumericalMathFunction of the given index */
	virtual NumericalMathFunction build(const UnsignedLong index) const;


	/** Return the measure upon which the basis is orthogonal */
	virtual Distribution getMeasure() const;

	/** Return the enumerate function that translate unidimensional indices nto multidimensional indices */
	virtual EnumerateFunction getEnumerateFunction() const;

	/** Virtual constructor */
	virtual OrthogonalFunctionFactory * clone() const;

	/** String converter */
	virtual String __repr__() const;


      protected:
	/** The measure that defines the scalar product */
	Distribution measure_;

	/** The enumerate function for product orthogonal functions */
	EnumerateFunction enumerateFunction_;

      private:

      } ; /* class OrthogonalFunctionFactory */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHOGONALFUNCTIONFACTORY_HXX */
