//                                               -*- C++ -*-
/**
 *  @file  ProjectionStrategyImplementation.hxx
 *  @brief This is a abstract class for projection strategy implementations
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_PROJECTIONSTRATEGYIMPLEMENTATION_HXX
#define OPENTURNS_PROJECTIONSTRATEGYIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "Distribution.hxx"
#include "Collection.hxx"
#include "NumericalMathFunction.hxx"
#include "Indices.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class ProjectionStrategyImplementation
       *
       * This is a abstract class for projection strategy implementations
       */

      class ProjectionStrategyImplementation
	: public Base::Common::PersistentObject
      {
	CLASSNAME;
	// Make the FunctionalChaosAlgorithm class a friend of the ProjectionStrategyImplementation class
	// as this last class is in charge of managing data that are part of the FunctionalChaosAlgorithm
	// state
	friend class FunctionalChaosAlgorithm;

      public:

	typedef Base::Common::StorageManager                  StorageManager;
	typedef Base::Type::NumericalPoint                    NumericalPoint;
	typedef Base::Func::NumericalMathFunction             NumericalMathFunction;
	typedef Base::Type::Collection<NumericalMathFunction> NumericalMathFunctionCollection;
	typedef Model::Distribution                           Distribution;
	typedef Base::Type::Indices                           Indices;

	// friend class Base::Common::Factory<ProjectionStrategyImplementation>;

	/** Default constructor */
	ProjectionStrategyImplementation();

	/** Parameter constructor */
	ProjectionStrategyImplementation(const Distribution & measure);

	/** Virtual constructor */
	virtual ProjectionStrategyImplementation * clone() const;

	/** String converter */
	virtual String __repr__() const;

	/** Measure accessor */
	virtual void setMeasure(const Distribution & measure);
	Distribution getMeasure() const;

	/** Compute the components alpha_k_p_ by projecting the model on the partial L2 basis */
	virtual void computeCoefficients(const NumericalMathFunction & function,
					 const NumericalMathFunctionCollection & partialBasis,
					 const Indices & indices,
					 const Indices & addedIndices,
					 const Indices & removedIndices);

	/** Method save() stores the object through the StorageManager */
	virtual void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(const StorageManager::Advocate & adv);


      protected:

	/** The collection of Alpha_k coefficients */
	NumericalPoint alpha_k_p_;

	/** Residual */
	NumericalScalar residual_p_;

	/** The measureing function for projection */
	Distribution measure_;

      private:

      } ; /* class ProjectionStrategyImplementation */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PROJECTIONSTRATEGYIMPLEMENTATION_HXX */
