//                                               -*- C++ -*-
/**
 *  @file  MarginalTransformationGradient.cxx
 *  @brief Class for the Nataf transformationGradient evaluation for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: MarginalTransformationGradient.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "MarginalTransformationGradient.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {



      CLASSNAMEINIT(MarginalTransformationGradient);

      /* Parameter constructor */
      MarginalTransformationGradient::MarginalTransformationGradient(const DistributionCollection & distributionCollection):
	NumericalMathGradientImplementation(),
	distributionCollection_(distributionCollection)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      MarginalTransformationGradient * MarginalTransformationGradient::clone() const
      {
	return new MarginalTransformationGradient(*this);
      }

      /* Gradient */
      MarginalTransformationGradient::Matrix MarginalTransformationGradient::gradient(const NumericalPoint & in) const
	throw (InvalidArgumentException, InternalException)
      {
	UnsignedLong dimension(getOutputNumericalPointDimension());
	Matrix result(dimension, dimension);
	// Apply PDF over the components
	for (UnsignedLong i = 0; i < dimension; ++i)
	  {
	    result(i, i) = distributionCollection_[i].computePDF(NumericalPoint(1, in[i]));
	  }
	return result;
      }
	  
      /* Accessor for input point dimension */
      UnsignedLong MarginalTransformationGradient::getInputNumericalPointDimension() const
	throw(InternalException)
      {
	return distributionCollection_.getSize();
      }

      /* Accessor for output point dimension */
      UnsignedLong MarginalTransformationGradient::getOutputNumericalPointDimension() const
	throw(InternalException)
      {
	return distributionCollection_.getSize();
      }

      /* String converter */
      String MarginalTransformationGradient::__repr__() const
      {
	OSS oss;
	oss << "class=" << MarginalTransformationGradient::GetClassName();                   
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

