//                                               -*- C++ -*-
/**
 *  @file  Analytical.hxx
 *  @brief Analytical implements an algorithm to find the design point
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Analytical.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_ANALYTICAL_HXX
#define OPENTURNS_ANALYTICAL_HXX

#include "Threadable.hxx"
#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalPointWithDescription.hxx"
#include "NearestPointAlgorithm.hxx"
#include "NearestPointChecker.hxx"
#include "Collection.hxx"
#include "Event.hxx"
#include "StandardEvent.hxx"
#include "NumericalSample.hxx"
#include "NumericalMathFunction.hxx"
#include "Graph.hxx"
#include "Description.hxx"
#include "AnalyticalResult.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class Analytical
       * NearestPointAlgorithm implements an algorithm to find the design point
       * and computes the results of an analytical result 
       */

      class Analytical
	: public Base::Common::PersistentObject,
	  public Base::Common::Threadable
      {

	CLASSNAME;
      public:

	typedef Base::Type::NumericalPoint                          NumericalPoint;
	typedef Base::Type::NumericalPointWithDescription           NumericalPointWithDescription;
	typedef Base::Type::Description                             Description;
	typedef Base::Optim::NearestPointAlgorithm           NearestPointAlgorithm;
	typedef Base::Func::NumericalMathFunction                   NumericalMathFunction;
	typedef Model::Distribution::NumericalPointCollection       NumericalPointCollection;
	typedef Model::Distribution::NumericalPointWithDescriptionCollection NumericalPointWithDescriptionCollection;
	typedef NumericalPointWithDescriptionCollection             Sensitivity;
	typedef Model::Event                                        Event;
	typedef Model::StandardEvent                                StandardEvent;
        typedef Base::Graph::Graph                                  Graph;
	typedef Graph::GraphCollection                              GraphCollection;

	/** Constructor with parameters */
	explicit Analytical(const NearestPointAlgorithm & nearestPointAlgorithm,
			    const Event & compositeEvent,
			    const NumericalPoint & physicalStartingPoint);


	/** Virtual constructor */
	virtual Analytical * clone() const;

	/** Physical starting point accessor */
	NumericalPoint getPhysicalStartingPoint() const;

	/** Physical starting point accessor */
	void setPhysicalStartingPoint(const NumericalPoint & physicalStartingPoint);

	/** Event accessor */
	Event getEvent() const;

	/** Event accessor */
	void setEvent(const Event & event);

	/** NearestPointAlgorithm accessor */
	NearestPointAlgorithm getNearestPointAlgorithm() const;

	/** NearestPointAlgorithm accessor */
	void setNearestPointAlgorithm(const NearestPointAlgorithm & nearestPointAlgorithm);

	/** Result accessor */
	virtual AnalyticalResult getAnalyticalResult() const;

	/** String converter */
	String __repr__() const;

	/** Performs the actual computation. */
	void run();

      protected:

      private:

	NearestPointAlgorithm nearestPointAlgorithm_;
	Event event_;
	NumericalPoint physicalStartingPoint_;
	AnalyticalResult result_;

      } ; /* class Analytical */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ANALYTICAL_HXX */
