//                                               -*- C++ -*-
/**
 *  @file  NumericalPointImplementationWithDescription.hxx
 *  @brief NumericalPointImplementationWithDescription extends the classical mathematical point with a description of the coordinates
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: NumericalPointImplementationWithDescription.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_NUMERICALPOINTIMPLEMENTATIONWITHDESCRIPTION_HXX
#define OPENTURNS_NUMERICALPOINTIMPLEMENTATIONWITHDESCRIPTION_HXX

#include "NumericalPointImplementation.hxx"
#include "Description.hxx"
#include "Pointer.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      /**
       * @class NumericalPointImplementationWithDescription
       *
       * NumericalPointImplementationWithDescription extends the classical mathematical point with a description of the coordinates
       */

      class NumericalPointImplementationWithDescription
	: public NumericalPointImplementation
      {
	CLASSNAME;

      public:

	typedef Common::StorageManager StorageManager;

	/** Default constructor */
	NumericalPointImplementationWithDescription();

	/** Constructor with size */
	NumericalPointImplementationWithDescription(const UnsignedLong size,
						    const NumericalScalar value = 0.0);

	/** Constructor from a collection */
	NumericalPointImplementationWithDescription(const Type::Collection<NumericalScalar> & coll);

	/** Constructor from a base class */
	NumericalPointImplementationWithDescription(const Common::Pointer<NumericalPointImplementation> & p_base);

	/** Virtual constructor */
	virtual NumericalPointImplementationWithDescription * clone() const;

	/** Description Accessor */
	void setDescription(const Description & description);
	Description getDescription() const;

	/** String converter */
	String __repr__() const;
	String __str__() const;


	/** Method save() stores the object through the StorageManager */
	virtual void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	virtual void load(const StorageManager::Advocate & adv);	

      private:

	/** The description of all components */
	Description::Implementation p_description_;

      }; /* class NumericalPointImplementationWithDescription */

      

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NUMERICALPOINTIMPLEMENTATIONWITHDESCRIPTION_HXX */
