//                                               -*- C++ -*-
/**
 *  @file  TNCSpecificParameters.cxx
 *  @brief SpecificParameters is an encapsulation of the TNC specific
 *         parameters.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: TNCSpecificParameters.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <cstdlib>

#include "TNC.hxx"
#include "ResourceMap.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(TNC::SpecificParameters);

      typedef Common::ResourceMap ResourceMap;

      const UnsignedLong    TNC::SpecificParameters::DefaultMaxCGit  = 50;//strtoul(ResourceMap::GetInstance().get("TNC-DefaultMaxCGit").c_str(), NULL, 0);
      const NumericalScalar TNC::SpecificParameters::DefaultEta      = 0.25;//strtod(ResourceMap::GetInstance().get("TNC-DefaultEta").c_str(), NULL);
      const NumericalScalar TNC::SpecificParameters::DefaultStepmx   = 10.0;//strtod(ResourceMap::GetInstance().get("TNC-DefaultStepmx").c_str(), NULL);
      const NumericalScalar TNC::SpecificParameters::DefaultAccuracy = 1.0e-4;//strtod(ResourceMap::GetInstance().get("TNC-DefaultAccuracy").c_str(), NULL);
      const NumericalScalar TNC::SpecificParameters::DefaultFmin     = 1.0;//strtod(ResourceMap::GetInstance().get("TNC-DefaultFmin").c_str(), NULL);
      const NumericalScalar TNC::SpecificParameters::DefaultRescale  = 1.3;//strtod(ResourceMap::GetInstance().get("TNC-DefaultRescale").c_str(), NULL);

      /* Default with parameters */
      TNC::SpecificParameters::SpecificParameters():
        PersistentObject(),
        scale_(0),
        offset_(0),
        maxCGit_(DefaultMaxCGit),
        eta_(DefaultEta),
        stepmx_(DefaultStepmx),
        accuracy_(DefaultAccuracy),
        fmin_(DefaultFmin),
        rescale_(DefaultRescale)
      {
        // Nothing to do
      } /* SpecificParametersTNC */

      /* Parameters with parameters */
      TNC::SpecificParameters::SpecificParameters(const NumericalPoint & scale,
                                                  const NumericalPoint & offset,
                                                  const UnsignedLong    maxCGit,
                                                  const NumericalScalar eta,
                                                  const NumericalScalar stepmx,
                                                  const NumericalScalar accuracy,
                                                  const NumericalScalar fmin,
                                                  const NumericalScalar rescale):
        PersistentObject(),
        scale_(scale),
        offset_(offset),
        maxCGit_(maxCGit),
        eta_(eta),
        stepmx_(stepmx),
        accuracy_(accuracy),
        fmin_(fmin),
        rescale_(rescale)
      {
        // Nothing to do
      } /* SpecificParametersTNC */

      /* Virtual constructor */
      TNC::SpecificParameters * TNC::SpecificParameters::clone() const
      {
        return new SpecificParameters(*this);
      }

      /* Scale accessor */
      TNC::NumericalPoint TNC::SpecificParameters::getScale() const
      {
        return scale_;
      }

      void TNC::SpecificParameters::setScale(const NumericalPoint & scale)
      {
        scale_ = scale;
      }

      /* Offset accessor */
      TNC::NumericalPoint TNC::SpecificParameters::getOffset() const
      {
        return offset_;
      }

      void TNC::SpecificParameters::setOffset(const NumericalPoint & offset)
      {
        offset_ = offset;
      }

      /* MaxCGit accessor */
      UnsignedLong TNC::SpecificParameters::getMaxCGit() const
      {
        return maxCGit_;
      }

      void TNC::SpecificParameters::setMaxCGit(const UnsignedLong maxCGit)
      {
        maxCGit_ = maxCGit;
      }

      /* Eta accessor */
      NumericalScalar TNC::SpecificParameters::getEta() const
      {
        return eta_;
      }

      void TNC::SpecificParameters::setEta(const NumericalScalar eta)
      {
        eta_ = eta;
      }

      /* Stepmx accessor */
      NumericalScalar TNC::SpecificParameters::getStepmx() const
      {
        return stepmx_;
      }

      void TNC::SpecificParameters::setStepmx(const NumericalScalar stepmx)
      {
        stepmx_ = stepmx;
      }

      /* Accuracy accessor */
      NumericalScalar TNC::SpecificParameters::getAccuracy() const
      {
        return accuracy_;
      }

      void TNC::SpecificParameters::setAccuracy(const NumericalScalar accuracy)
      {
        accuracy_ = accuracy;
      }

      /* Fmin accessor */
      NumericalScalar TNC::SpecificParameters::getFmin() const
      {
        return fmin_;
      }

      void TNC::SpecificParameters::setFmin(const NumericalScalar fmin)
      {
        fmin_ = fmin;
      }

      /* Rescale accessor */
      NumericalScalar TNC::SpecificParameters::getRescale() const
      {
        return rescale_;
      }

      void TNC::SpecificParameters::setRescale(const NumericalScalar rescale)
      {
        rescale_ = rescale;
      }

      /* String converter */
      String TNC::SpecificParameters::__repr__() const
      {
        OSS oss;
        oss << "class=" << TNC::SpecificParameters::GetClassName()
            << " scale=" << scale_
            << " offset=" << offset_
            << " maxCGit=" << maxCGit_
            << " eta=" << eta_
            << " stepmx=" << stepmx_
            << " accuracy=" << accuracy_
            << " fmin=" << fmin_
            << " rescale=" << rescale_;
        return oss;
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */



