//                                               -*- C++ -*-
/**
 *  @file  Staircase.hxx
 *  @brief Staircase class for handling staircase plots
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: Staircase.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_STAIRCASE_HXX
#define OPENTURNS_STAIRCASE_HXX

#include "DrawableImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      /**
       * @class Staircase
       *
       * The class describing a staircase plot
       * Instance of Drawable
       */

      class Staircase : public DrawableImplementation
      {

	CLASSNAME;

      public:
	
	typedef DrawableImplementation::NumericalSample          NumericalSample;
	typedef DrawableImplementation::InvalidArgumentException InvalidArgumentException;
	
	Staircase(const NumericalSample & data,
		  const String & legend = NoSpecifiedLabel);

	/** Constructor with parameters */
	Staircase(const NumericalSample & data,
		  const String & color,
		  const String & lineStyle,
		  const String & pattern,
		  const String & legend = NoSpecifiedLabel)
	  throw(InvalidArgumentException);

	/** String converter */
	String __repr__() const;

	/** Draw method */
	String draw() const;

	/** Clone method */
	Staircase * clone() const;
	
	/** Accessor for pattern */
	String getPattern() const;
	void setPattern(const String style) throw(InvalidArgumentException);

	/** Check fo data validity */
	Bool isValidData(const NumericalSample & data) const;

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

 	/** Method load() stores the object through the StorageManager */
	void load(const StorageManager::Advocate & adv);

      private:

	Staircase() {};
	friend class Base::Common::Factory<Staircase>;

	/** Pattern for staircase plotting */
	String pattern_; // should be either "S" or "s"

      }; /* class Staircase */

    }/* namespace Graph */

  }/*namespace Base */

}/* namespace OpenTURNS */

#endif /* OPENTURNS_STAIRCASE_HXX */
