//                                               -*- C++ -*-
/**
 * @file  ProductNumericalMathEvaluationImplementation.hxx
 * @brief The class that implements the composition between numerical
 *        math functions implementations
 *
 * (C) Copyright 2005-2006 EADS
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: lebrun $
 * \date   $LastChangedDate: 2008-07-03 08:31:34 +0200 (jeu, 03 jui 2008) $
 */

#ifndef OPENTURNS_PRODUCTNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX
#define OPENTURNS_PRODUCTNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX

#include "NumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class ProductNumericalMathEvaluationImplementation
       *
       * The class that implement the composition of two numerical math functions implementations.
       */
      class ProductNumericalMathEvaluationImplementation 
	: public NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	/* Some typedefs for easy reading */
	typedef NumericalMathEvaluationImplementation::NumericalPoint           NumericalPoint;
	typedef NumericalMathEvaluationImplementation::NumericalSample          NumericalSample;
	typedef Common::Pointer<NumericalMathEvaluationImplementation>          EvaluationImplementation;
	typedef NumericalMathEvaluationImplementation::InvalidArgumentException InvalidArgumentException;
	typedef NumericalMathEvaluationImplementation::InternalException        InternalException;
	typedef NumericalMathEvaluationImplementation::NumericalPointWithDescription NumericalPointWithDescription;

	/** Default constructor */
	ProductNumericalMathEvaluationImplementation(const EvaluationImplementation & p_leftEvaluation,
						      const EvaluationImplementation & p_rightEvaluation) throw(InvalidArgumentException);


	/** Virtual constructor */
	virtual ProductNumericalMathEvaluationImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const ProductNumericalMathEvaluationImplementation & other) const;

	/** String converter */
	virtual String __repr__() const;

	/** Operator () */
	NumericalPoint operator() (const NumericalPoint & in) const
	  throw(InvalidArgumentException,InternalException);

	NumericalSample operator() (const NumericalSample & in) const
	  throw(InvalidArgumentException,InternalException);

	/** Parameters value and description accessor */
	virtual NumericalPointWithDescription getParameters() const;
	virtual void setParameters(const NumericalPointWithDescription & parameters);

	/** Accessor for input point dimension */
	UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);

      protected:

	ProductNumericalMathEvaluationImplementation() {};
	friend class Common::Factory<ProductNumericalMathEvaluationImplementation>;
    
      private:

	/** The function f in h = f . g */
	EvaluationImplementation p_leftEvaluation_;

	/** The function g in h = f . g */
	EvaluationImplementation p_rightEvaluation_;

      }; /* class ProductNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PRODUCTNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX */
