//                                               -*- C++ -*-
/**
 *  @file  LinearNumericalMathFunction.hxx
 *  @brief The class that implements linear numerical math functions.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: LinearNumericalMathFunction.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_LINEARNUMERICALMATHFUNCTION_HXX
#define OPENTURNS_LINEARNUMERICALMATHFUNCTION_HXX

#include "NumericalMathFunction.hxx"
#include "NumericalPoint.hxx"
#include "Matrix.hxx"
#include "Exception.hxx"
#include "LinearNumericalMathEvaluationImplementation.hxx"
#include "ConstantNumericalMathGradientImplementation.hxx"
#include "ConstantNumericalMathHessianImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class LinearNumericalMathFunction
       *
       * The class that simulates a linear numerical math function,
       * its gradient and its hessian. This class is just an interface
       * to actual implementation objects that can be hot-replaced
       * during computation. Each implementation object refers to
       * the function, the gradient or the hessian.
       */
      class LinearNumericalMathFunction 
	: public NumericalMathFunction
      {
	CLASSNAME;
      public:

	/* Some typedefs for easy reading */
	typedef Type::NumericalPoint              NumericalPoint;
	typedef Type::Matrix                      Matrix;
	typedef Type::SymmetricTensor             SymmetricTensor;
	typedef Common::InvalidDimensionException InvalidDimensionException;

	/** Default constructor */
	LinearNumericalMathFunction(const NumericalPoint & center,
                                    const NumericalPoint & constant,
                                    const Matrix & linear);


	/** Comparison operator */
	Bool operator ==(const LinearNumericalMathFunction & other) const;

	/** String converter */
	virtual String __repr__() const;

      }; /* class LinearNumericalMathFunction */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LINEARNUMERICALMATHFUNCTION_HXX */
