//                                               -*- C++ -*-
/**
 *  @file  ComparisonOperatorImplementation.hxx
 *  @brief Abstract top-level class for all ComparisonOperatorImplementation
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: ComparisonOperatorImplementation.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_COMPARISONOPERATORIMPLEMENTATION_HXX
#define OPENTURNS_COMPARISONOPERATORIMPLEMENTATION_HXX

#include "OTprivate.hxx"
#include "PersistentObject.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {


      /**
       * @class ComparisonOperatorImplementation
       *
       * The class describes the probabilistic concept of ComparisonOperatorImplementation.
       */
      class ComparisonOperatorImplementation 
	: public PersistentObject
      {
	CLASSNAME;
      public:

	/** Default constructor */
	ComparisonOperatorImplementation();

	/** String converter */
	String __repr__() const;


	/* Here is the interface that all derived class must implement */

	/** Virtual constructor */
	virtual ComparisonOperatorImplementation * clone() const = 0;

	/** Return true if comparison succeeds */
	virtual Bool operator() (NumericalScalar a, NumericalScalar b) const = 0;

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;
  
	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);

      }; /* class ComparisonOperatorImplementation */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPARISONOPERATORIMPLEMENTATION_HXX */
