# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header$

inherit eutils

DESCRIPTION="Cross platform, object orientated threading library maintained by the OpenSceneGraph team."
HOMEPAGE="http://www.openscenegraph.org"
MY_P="openscenegraph-${PV}.tar.gz"
SRC_URI="http://download.gna.org/underware/sources/${MY_P}"
SLOT="0"
LICENSE="LGPL-2.1"
KEYWORDS="x86"
IUSE="debug"

DEPEND="virtual/x11 =dev-cpp/openthreads-1.0.0* jpeg tiff freetype >=media-libs/libpng-1.2 lib3ds"

COMPILE_OSG_OP_OT_WITH_SONAMES=YES
S="${WORKDIR}/openscenegraph-${PV}/OpenSceneGraph"
EPATCH_OPTS="-p1 -d ${WORKDIR}/openscenegraph-${PV}"
src_unpack() {
	unpack ${MY_P}
	if ls ${FILESDIR}/${PVR}*.patch 2>/dev/null
		then
		for i in ${FILESDIR}/${PVR}*.patch
		  do
		  epatch $i
		done
	fi
}

src_compile() {
    echo "FEATURES $FEATURES"
    CCACHE=$(echo $FEATURES | sed 's/.*ccache.*/ccache/g')
    export LIBUNGIF_INSTALLED=no
    if use debug; then
        emake CXX="${CCACHE} g++" debug || die
    else
	    emake CXX="${CCACHE} g++" OPTF="'${CXXFLAGS}'" || die
    fi

}

src_install() {
	emake install INST_LOCATION="${D}/usr" || die "einstall failed"
	insinto "/usr/lib/pkgconfig"
	doins ${S}/Make/openscenegraph.pc
}
