/* -*-c++-*- Producer - Copyright (C) 2001-2004  Don Burns
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
 */

//
// Ugh.. for usleep.  Need to come up with a cleaner solution than usleep
#ifdef WIN32
#include <windows.h>
#if ! defined (__CYGWIN__) && ! defined(__MINGW32__)
#define usleep(x) Sleep((x)/1000)
#endif
#else
#include <unistd.h>
#endif

#include <Producer/Referenced>
#include <Producer/InputArea>
#include <Producer/RenderSurface>

using namespace Producer;

InputArea::InputArea(): _initialized(false)
{
    _minX = _maxX = _minY = _maxY = 0.0f;
}

InputArea::~InputArea()
{
}

void InputArea::addRenderSurface( RenderSurface *rs )
{
    // Useless to addInputRectangle after initialization
    if( _initialized ) return;
    _mapdata.push_back( rs );

    RenderSurface::InputRectangle ir = rs->getInputRectangle();

    if(_minX == 0.0f || _minX > ir.left() )
        _minX = ir.left();

    if(_maxX == 0.0f || _maxX < (ir.left()+ir.width()) )
        _maxX = ir.left() + ir.width();

    if(_minY == 0.0f || _minY > ir.bottom() )
        _minY = ir.bottom();

    if(_maxY == 0.0f || _maxY < (ir.bottom()+ir.height()) )
        _maxY = ir.bottom() + ir.height();
}

bool InputArea::_init()
{
    if( _initialized ) return _initialized;

    // Wait for realiziation
    while( _waitForRealize() == false )
           ;
    std::vector <RenderSurface *>::iterator p;
    for( p = _mapdata.begin(); p != _mapdata.end(); p++ )
    {
        RenderSurface *rs = (*p);
        Window win = rs->getWindow();
        _winmap.insert(std::pair<Window,RenderSurface *>(win,(*p)));

    }
    return (_initialized = true);
}



bool InputArea::_waitForRealize()
{
    std::vector <RenderSurface *>::iterator p;
    for( p = _mapdata.begin(); p != _mapdata.end(); p++ )
    {
        RenderSurface *rs = (*p);
        if( rs->waitForRealize() == false )
            return false;
    }
    return true;
}

bool InputArea::isRealized()
{
    bool retval = true;
    std::vector <RenderSurface *>::iterator p;
    for( p = _mapdata.begin(); p != _mapdata.end(); p++ )
    {
        RenderSurface *rs = (*p);
        if( rs->isRealized() == false )
        {
            retval = false;
            break;
        }
    }
    return retval;
}

void InputArea::normalizeMouseMotion( Window win, int mx, int my, float &nmx, float &nmy )
{
    transformMouseMotion(win,mx,my,nmx,nmy);
    normalizeXY(nmx,nmy);
}

void InputArea::transformMouseMotion( Window win, int mx, int my, float &tmx, float &tmy )
{
    if( !_initialized  && !_init() ) return;

    std::map<Window,RenderSurface *>::iterator p = _winmap.find(win);
    if( p == _winmap.end() )
        return;

    RenderSurface *rs = (*p).second;
    RenderSurface::InputRectangle ir = rs->getInputRectangle();

    tmx = ir.left() + (float(mx)/float(rs->getWindowWidth()-1)) * ir.width();
    my = rs->getWindowHeight() - (my + 1);
    tmy = ir.bottom() + (float(my)/float(rs->getWindowHeight()-1)) * ir.height();
}

RenderSurface *InputArea::getRenderSurface(int index)
{
    int i;
    std::vector <RenderSurface *>::iterator p;
    for( i = 0, p = _mapdata.begin(); 
        p != _mapdata.end();
        p++, i++ )
    {
        if( i == index ) break;
    }
    if( p == _mapdata.end() )
        return NULL;
    else
        return (*p);
}

#if 0
RenderSurface::InputRectangle *InputArea::getInputRectangle(int index)
{
    int i;
    std::vector <RenderSurface *>::iterator p;
    for( i = 0, p = _mapdata.begin(); 
        p != _mapdata.end();
        p++, i++ )
    {
        if( i == index ) break;
    }
    if( p == _mapdata.end() )
        return NULL;
    else
        return &((*p)->getInputRectangle());
}
#endif

Window InputArea::getWindow(int index)
{
    if( !_initialized ) _init();
    std::map<Window,RenderSurface *>::iterator p;
    int i;
    for( i = 0, p = _winmap.begin(); p != _winmap.end(); p++, i++ )
    {
        if( i == index )
            break;
    }
    if( p != _winmap.end() )
        return p->first;
    else
        return (Window)0L;
}

int InputArea::getNumRenderSurfaces()
{
    if( !_initialized ) _init();
    return _winmap.size();
}

int InputArea::getNumWindows()
{
    if( !_initialized ) _init();
    return _winmap.size();
}

void InputArea::getExtents( float &minX, float &maxX, float &minY, float &maxY )
{
    minX = _minX;
    maxX = _maxX;
    minY = _minY;
    maxY = _maxY;
}

void InputArea::getCenter( float &cx, float &cy )
{
    cx = (_minX + _maxX) * 0.5;
    cy = (_minY + _maxY) * 0.5;
}

void InputArea::normalizeXY( float &x, float &y )
{
    float cx, cy;
    getCenter(cx,cy);
    float width = _maxX - _minX;
    float height = _maxY - _minY;
    x = (x - cx)/(width*0.5);
    y = (y - cy)/(height*0.5);
}
