/* -*-c++-*- Producer - Copyright (C) 2001-2004  Don Burns
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
 */

// Simple example of use of Producer::Camera
// The MySceneHandler class is a simple sample of a Camera::SceneHandler

#include <Producer/CameraGroup>
#include <Producer/CameraConfig>
#include "MySceneHandler"
#include "MySceneHandler2"

int main()
{
	Producer::Camera camera1;
	Producer::Camera camera2;

	Producer::RenderSurface *rs = camera1.getRenderSurface();
	rs->setWindowRect( 100, 100, 640, 480 );
	rs->setWindowName( "Producer example using two Cameras, one ProjectionRectangle" );

	camera2.setRenderSurface(rs);


	camera1.setSceneHandler( new MySceneHandler );
    camera1.setViewByLookat( 0.0f, 0.0f, 15.0f,   /// Position of the eye
                     0.0f, 0.0f, 0.0f,   /// Point the eye is looking at
                     0.0f, 1.0f, 0.0f ); /// Up

	camera2.setSceneHandler( new MySceneHandler2 );
    camera2.setViewByLookat( 0.0f, 0.0f, 45.0f,   /// Position of the eye
                     0.0f, 0.0f, 0.0f,   /// Point the eye is looking at
                     0.0f, 1.0f, 0.0f ); /// Up

	// If using camera group, use this code
	Producer::CameraConfig cfg;
	cfg.addCamera("Camera 1", &camera1);
	cfg.addCamera("Camera 2", &camera2);
	Producer::CameraGroup cg(&cfg);

	//cg.realize( Producer::CameraGroup::SingleThreaded );
	cg.realize( Producer::CameraGroup::ThreadPerCamera );
	// end if using camera group
	
	while( cg.validForRendering() )
	//while( true )
	{
		// if using camera group
		cg.frame();
		// else
		/*
		camera1.frame(false);
		camera2.frame(false);
		// We only need to advance on camera as that will swap buffers
		// on a single shared render surface
		camera1.advance();
		*/
		// end if using camera group
	}
	return 0;
}
