/*************************************************************************
 *
 *  $RCSfile: OOoTransformProps.java,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/10 13:31:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2002 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**
 * Description: This class is used for the transformation of Global documents.
 * For each child document referenced by a URL of the text:section a transformation will
 * be started.
 * This is necessary as global document children don't 'know' of each other nor of the global
 * document.
 * Due to that no consequence numbering of the chapter would be possible nor a HTML linking between
 * child documents an to the content-table (global document).
 * The class collects all necessary parameters and starts the transformation of each child document.
 *
 * This class works only with the XT processor of James Clark. This was the easiest way to go and should be
 * expanded/splitt later.
 * <p>
 *	For further documentation and updates visit http://xml.openoffice.org/sx2ml
 */
package org.openoffice.xslt;

import java.io.*;
import java.util.*;
import java.net.*;
import java.lang.reflect.Array;

import org.xml.sax.*;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.helpers.XMLReaderAdapter;
import com.jclark.xsl.expr.*;
import com.jclark.xsl.om.*;
import java.lang.NullPointerException;
import javax.xml.parsers.SAXParserFactory;


class OOoTransformProps
{

    private static String mRelativeSourceDirURL;
    private static String destinationDirURL;
    private static String mAbsoluteSourceDirURL;
    static String mStyleDebugOutputOnly;
    static String jarRootURL;
    static String optionalURLSuffix;
    static String mContentTableURL;
    static String masterDocumentDir;
    static String dpi;
    static String stylesFileURL;
    static String metaFileURL;
    static String mOutputType;
    static String xslStylesheet;
    static boolean mDebug = false;
    static boolean mbZippedSource;
    static boolean mMasterDocument;
    // master document choice has been made
    static boolean mMasterDocumentEnabled;

    static void setDestinationDirURL(String path){
        if(path == null)
            destinationDirURL = null;
        else
            destinationDirURL = path.endsWith("/") ? path : path + '/';
    }


    static String getDestinationDirURL(){
        return destinationDirURL;
    }

    static String getMasterDocumentDir(){
        return masterDocumentDir;
    }


    /** Sets XSLT Processor Property */
    static void setOutputType(String outputType){
        if(outputType == null){
            System.out.println("\nThe parameter 'outputType' was not set, 'CSS_HEADER' is taken as default.");
            mOutputType = "CSS_HEADER";
        }else{
            mOutputType = outputType;
            System.out.println("\nThe outputType is " + outputType);
        }
    }

    /** Sets XSLT Processor Property */
    static void setAbsoluteSourceDirURL(String path) throws NullPointerException{
            if(path == null){
                System.err.println("Usage: The parameter 'sourceDirURL' giving the absolute path to the source file is not set.");
                throw new NullPointerException();
            }else{
                //try{
                //    mAbsoluteSourceDirURL = new File(path).toURL().toString();
                      mAbsoluteSourceDirURL = path.replace('\\','/').endsWith("/") ? path : path + '/';
/*                }catch(java.net.MalformedURLException e){
                    System.out.println("Error: Path of sourceDir couldn't be changed to an URL");
                    e.printStackTrace();
                 }*/
            }
            if(mDebug) System.out.println("sourceDirURL was set to " + mAbsoluteSourceDirURL);
    }

    static String getAbsoluteSourceDirURL() {
        return mAbsoluteSourceDirURL;
    }

    static void setRelativeSourceDirURL(String sourceURL, String destinationURL) throws NullPointerException{
        mRelativeSourceDirURL = OOoMasterDocument.getRelativeURL(sourceURL, destinationURL);
        if(mDebug)  System.out.println("The relativeSourceDirURL is set to " + mRelativeSourceDirURL);
    }

    static String getRelativeSourceDirURL() {
        return mRelativeSourceDirURL;
    }


    static String getJarRootURL(){
        return jarRootURL;
    }


    static void setMasterDocumentDir(String inputFile){
            masterDocumentDir = OOoTransform.file2URL(new File(inputFile)).toString();
            // removing the file name
            masterDocumentDir = masterDocumentDir.substring(0, masterDocumentDir.lastIndexOf('/') + 1 );
            // removing the file protocol (and Windows Drive letter)
            //MasterDocumentDir = masterDocumentDir.substring(masterDocumentDir.lastIndexOf(':') + 1);
            // XT EXCEPTION WITH DOS LETTER
            masterDocumentDir = masterDocumentDir.substring(masterDocumentDir.indexOf(":") + 2);
            if(mDebug)System.out.println("MasterDocumentDir: " + masterDocumentDir);
    }


    static void setContentTableURL(String ref){
        if(ref.indexOf(':') < 0)
            mContentTableURL = OOoTransform.file2URL(new File(ref)).toString();
        else
            mContentTableURL = ref;
    }

    public static String getContentTableURL(){
        return mContentTableURL;
    }

}
