/*************************************************************************
 *
 *  $RCSfile: rmtconn.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: kso $ $Date: 2001/09/12 10:03:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTCONN_HXX_
#include <rmtconn.hxx>
#endif

#ifndef _COM_SUN_STAR_BRIDGE_XUNOURLRESOLVER_HPP_
#include <com/sun/star/bridge/XUnoUrlResolver.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#if defined UCB_RAP_OFFLINE
#ifndef _COM_SUN_STAR_SYNC_SYNCHRONIZECOMMANDARGUMENT_HPP_
#include <com/sun/star/sync/SynchronizeCommandArgument.hpp>
#endif
#endif // UCB_RAP_OFFLINE
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEAUGMENTEDIOEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveAugmentedIOException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDER_HPP_
#include <com/sun/star/ucb/XContentProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERCHANGELISTENER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERCHANGENOTIFIER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERSUPPLIER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_URI_HXX_
#include <rtl/uri.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _UCBHELPER_FILEIDENTIFIERCONVERTER_HXX_
#include <ucbhelper/fileidentifierconverter.hxx>
#endif

#if defined UCB_RAP_OFFLINE
#ifndef INCLUDED_UCB_RAPOFFLINEPROVIDER_HXX
#include <rapofflineprovider.hxx>
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTROAGE_HXX
#include <rapofflinestorage.hxx>
#endif
#endif // UCB_RAP_OFFLINE
#ifndef _UCPRMT_RMTCONT_HXX_
#include <rmtcont.hxx>
#endif
#ifndef _UCPRMT_RMTLID_HXX_
#include <rmtlid.hxx>
#endif
#ifndef _UCPRMT_RMTPROV_HXX_
#include <rmtprov.hxx>
#endif

// Definitions for RegexpToBoolMap (Solaris wouldn't find explicit template
// instantiations for these in another compilation unit...):
#ifndef _UCB_REGEXPMAP_TPT_
#include <regexpmap.tpt>
#endif

using namespace com::sun;
using namespace com::sun::star;
using namespace ucprmt;

//============================================================================
//
//  ConnectionMap
//
//============================================================================

void ConnectionMap::releaseConnection(Connection * pConnection) throw ()
{
    OSL_ASSERT(pConnection);

    osl::MutexGuard aGuard(m_aMutex);

    if (osl_decrementInterlockedCount(&pConnection->m_nRefCount) == 0)
    {
        HashMap::iterator aEnd(m_aProviderToConnectionMap.end());
        for (HashMap::iterator aIt(m_aProviderToConnectionMap.begin());
             aIt != aEnd; ++aIt)
            if (aIt->second == pConnection)
            {
                m_aProviderToConnectionMap.erase(aIt);
                break;
            }
        delete pConnection;
    }
}

//============================================================================
ConnectionMap::ConnectionMap(
    uno::Reference< lang::XMultiServiceFactory > const & rTheFactory,
    rtl::Reference< ContentProvider > const & rTheProvider):
    m_xFactory(rTheFactory),
    m_xProvider(rTheProvider)
{
    OSL_ASSERT(m_xFactory.is() && m_xProvider.is());
}

//============================================================================
rtl::Reference< ContentProvider > ConnectionMap::getProvider() const
{
    return m_xProvider;
}

//============================================================================
rtl::Reference< Connection >
ConnectionMap::getConnection(rtl::OUString const & rRemoteProviderURL)
{
    OSL_ASSERT(rRemoteProviderURL.getLength() != 0);

    osl::MutexGuard aGuard(m_aMutex);

    HashMap::const_iterator
        aIt(m_aProviderToConnectionMap.find(rRemoteProviderURL));
    if (aIt == m_aProviderToConnectionMap.end())
        aIt = m_aProviderToConnectionMap.
                      insert(HashMap::value_type(rRemoteProviderURL,
                                                 new Connection(
                                                         m_xFactory, this,
                                                         rRemoteProviderURL,
                                                         m_aUUIDSupplier))).
                  first;
    return aIt->second;
}

//============================================================================
//
//  Connection
//
//============================================================================

class Connection::ChangeListener:
    public cppu::WeakImplHelper1<
               star::ucb::XRemoteContentProviderChangeListener >
{
public:
    inline
    ChangeListener(
        Connection * pConnection,
        uno::Reference<
                star::ucb::XRemoteContentProviderChangeNotifier > const &
            rNotifier,
        rtl::OUString const & rIdentifier);

    void clear();

    virtual void SAL_CALL disposing(lang::EventObject const & rSource)
        throw (uno::RuntimeException);

    virtual void SAL_CALL
    remoteContentProviderChange(
        star::ucb::RemoteContentProviderChangeEvent const & rEvent)
        throw (uno::RuntimeException);

private:
    osl::Mutex m_aMutex;
    rtl::OUString m_aIdentifier;
    uno::Reference< star::ucb::XRemoteContentProviderChangeNotifier >
        m_xNotifier;
    Connection * m_pConnection;
};

inline
Connection::ChangeListener::ChangeListener(
    Connection * pConnection,
    uno::Reference< star::ucb::XRemoteContentProviderChangeNotifier > const &
        rNotifier,
    rtl::OUString const & rIdentifier):
    m_pConnection(pConnection),
    m_xNotifier(rNotifier),
    m_aIdentifier(rIdentifier)
{}

void Connection::ChangeListener::clear()
{
    osl::MutexGuard aGuard(m_aMutex);
    m_pConnection = 0;
}

void SAL_CALL
Connection::ChangeListener::disposing(lang::EventObject const & rSource)
    throw (uno::RuntimeException)
{
    //TODO! atomic actions on m_xNotifier?
    if (rSource.Source == m_xNotifier)
        m_xNotifier = 0;
}

void SAL_CALL
Connection::ChangeListener::remoteContentProviderChange(
    star::ucb::RemoteContentProviderChangeEvent const & rEvent)
    throw (uno::RuntimeException)
{
    //TODO! atomic actions on m_xNotifier?
    if (rEvent.Source == m_xNotifier
        && rEvent.Identifier == m_aIdentifier
        && rEvent.Action
               == star::ucb::RemoteContentProviderChangeAction_REMOVED)
    {
        // resetRemoteProvider() will also lock Connection's mutex, but that
        // is save, because the pattern is that if both Connection's mutex and
        // ChangeListener's mutex are locked, then ChangeListener's mutex is
        // always locked first (since the only other place where
        // ChangeListener's mutex is locked, clear(), is only called from
        // Connection's destructor, when Connection's mutex is guaranteed to
        // be unlocked):
        osl::MutexGuard aGuard(m_aMutex);
        if (m_pConnection)
            m_pConnection->resetRemoteProvider();
    }
}

//============================================================================
uno::Reference< star::ucb::XContentProvider > Connection::getRemoteProvider()
    throw (connection::NoConnectException,
           connection::ConnectionSetupException,
           lang::IllegalArgumentException, uno::RuntimeException)
{
    if (!m_xRemoteProvider.is())
#if defined UCB_RAP_OFFLINE
        if (m_xOfflineProvider.is())
            m_xRemoteProvider = m_xOfflineProvider.get();
        else
#endif // UCB_RAP_OFFLINE
        {
            uno::Reference< lang::XMultiServiceFactory > xRemoteFactory;
            sal_Int32 nIdentifierEnd;
            if (m_aRemoteProviderURL.
                    equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
                                     "uno:SELF;urp;UCB.Factory")))
            {
                xRemoteFactory = m_xFactory;

                m_nLocalityFactor = 100;
            }
            else if (m_aRemoteProviderURL.
                     compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                        "uno:FACTORY,id="))
                         == 0
                     && (nIdentifierEnd
                                 = m_aRemoteProviderURL.
                                       indexOf(';',
                                               RTL_CONSTASCII_LENGTH(
                                                   "uno:FACTORY,id=")))
                            >= 0
                     && m_aRemoteProviderURL.
                            copy(nIdentifierEnd).
                                equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
                                                 ";urp;UCB.Factory")))
            {
                rtl::OUString
                    aIdentifier(
                        rtl::Uri::decode(
                            m_aRemoteProviderURL.
                                copy(RTL_CONSTASCII_LENGTH("uno:FACTORY,id="),
                                     nIdentifierEnd
                                         - RTL_CONSTASCII_LENGTH(
                                             "uno:FACTORY,id=")),
                            rtl_UriDecodeWithCharset,
                            RTL_TEXTENCODING_UTF8));

                uno::Reference< star::ucb::XRemoteContentProviderSupplier >
                    xSupplier;
                try
                {
                    xSupplier
                        = uno::Reference<
                                  star::ucb::XRemoteContentProviderSupplier >(
                              m_xFactory->
                                  createInstance(
                                      rtl::OUString(
                                          RTL_CONSTASCII_USTRINGPARAM(
                          "com.sun.star.ucb.RemoteContentProviderAcceptor"))),
                              uno::UNO_QUERY);
                }
                catch (uno::RuntimeException &)
                {
                    throw;
                }
                catch (uno::Exception &)
                {}
                if (!xSupplier.is())
                    throw uno::RuntimeException();
                        // no service, or service lacks interface

                if (!m_xChangeListener.is())
                {
                    uno::Reference<
                            star::ucb::XRemoteContentProviderChangeNotifier >
                        xNotifier(xSupplier, uno::UNO_QUERY);
                    OSL_ENSURE(xNotifier.is(),
                               "remote content provider supplier not"
                                   " change notifier");
                    if (xNotifier.is())
                    {
                        m_xChangeListener = new ChangeListener(this,
                                                               xNotifier,
                                                               aIdentifier);
                        xNotifier->addRemoteContentProviderChangeListener(
                                       m_xChangeListener.get());
                    }
                }

                xRemoteFactory
                    = xSupplier->queryRemoteContentProvider(aIdentifier);
                if (!xRemoteFactory.is())
                    throw connection::NoConnectException();

                m_nLocalityFactor = 25;
            }
            else
            {
                uno::Reference< bridge::XUnoUrlResolver > xResolver;
                try
                {
                    xResolver
                        = uno::Reference< bridge::XUnoUrlResolver >(
                              m_xFactory->
                                  createInstance(
                                      rtl::OUString(
                                          RTL_CONSTASCII_USTRINGPARAM(
                                      "com.sun.star.bridge.UnoUrlResolver"))),
                              uno::UNO_QUERY);
                }
                catch (uno::RuntimeException &)
                {
                    throw;
                }
                catch (uno::Exception &)
                {}
                if (!xResolver.is())
                    throw uno::RuntimeException();
                        // no service, or service lacks interface

                xRemoteFactory = uno::Reference< lang::XMultiServiceFactory >(
                                     xResolver->resolve(m_aRemoteProviderURL),
                                     uno::UNO_QUERY);
                if (!xRemoteFactory.is())
                    throw uno::RuntimeException();
                        // bad resolve() result, or service lacks interface

                try
                {
                    xRemoteFactory
                        = uno::Reference< lang::XMultiServiceFactory >(
                              xRemoteFactory->
                                  createInstance(
                                      rtl::OUString(
                                          RTL_CONSTASCII_USTRINGPARAM(
                                        "com.sun.star.lang.ServiceManager"))),
                              uno::UNO_QUERY);
                }
                catch (uno::RuntimeException &)
                {
                    throw;
                }
                catch (uno::Exception &)
                {}
                if (!xRemoteFactory.is())
                    throw uno::RuntimeException();
                        // no service, or service lacks interface

                // All 'portal' and 'socket' connections without a 'host'
                // parameter, as well as all 'pipe' connections are considered
                // to have 75% locality, all others are considered to have 50%
                // locality:
                m_nLocalityFactor
                    = (m_aRemoteProviderURL.
                               compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                                  "uno:portal"))
                           == 0
                       || m_aRemoteProviderURL.
                                  compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                                     "uno:socket"))
                              == 0)
                          && m_aRemoteProviderURL.
                                     indexOf(rtl::OUString::createFromAscii(
                                                 ",host="))
                                 == -1
                      || m_aRemoteProviderURL.
                                 compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                                    "uno:pipe"))
                             == 0 ?
                          75 : 50;
                //TODO! The conditions are somewhat crude...
            }

            try
            {
                //TODO! The remote broker service should be created using
                // createInstanceWithArguments(), specifing whether and how
                // the broker should be configured.  Not supplying these
                // arguments implies that the remote broker service must
                // already be instantiated and configured when this call is
                // made:
                m_xRemoteProvider
                    = uno::Reference< star::ucb::XContentProvider >(
                          xRemoteFactory->
                              createInstance(
                                  rtl::OUString(
                                      RTL_CONSTASCII_USTRINGPARAM(
                                 "com.sun.star.ucb.UniversalContentBroker"))),
                          uno::UNO_QUERY);
            }
            catch (uno::RuntimeException &)
            {
                throw;
            }
            catch (uno::Exception &)
            {}
            if (!m_xRemoteProvider.is())
                throw uno::RuntimeException();
                    // no service, or service lacks interface
        }

    return m_xRemoteProvider;
}

//============================================================================
void Connection::resetRemoteProvider()
{
    osl::MutexGuard aGuard(m_aMutex);
    m_xRemoteProvider = 0;
}

//============================================================================
uno::Reference< star::ucb::XContentIdentifier >
Connection::mapToRemoteIdentifier(
    uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier) const
    throw (uno::RuntimeException)
{
    if (isLocalIdentifier(rIdentifier))
        return static_cast< LocalContentIdentifier * >(rIdentifier.get())->
                   getRemoteIdentifier();
    else if (rIdentifier.is())
    {
        rtl::OUString aURI(rIdentifier->getContentIdentifier());
        if (aURI.getLength() != 0)
        {
            bool bTranslated;
            if (m_aLocalToRemoteURIs.map(aURI, &aURI, &bTranslated)
                && bTranslated)
                return new ::ucb::ContentIdentifier(aURI);
        }
    }
    return rIdentifier;
}

//============================================================================
uno::Reference< star::ucb::XContentIdentifier >
Connection::normalizeLocalIdentifier(
    uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier) const
    throw (uno::RuntimeException)
{
    if (rIdentifier.is())
    {
        rtl::OUString aURI(rIdentifier->getContentIdentifier());
        if (aURI.compareTo(m_aLocalURIPrefix, m_aLocalURIPrefix.getLength())
                == 0
            && m_aRemoteToLocalURIs.map(aURI.copy(m_aLocalURIPrefix.
                                                      getLength()),
                                        &aURI))
            return new ::ucb::ContentIdentifier(aURI);
    }
    return rIdentifier;
}

//============================================================================
bool
Connection::isLocalIdentifier(
    uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier) const
    throw (uno::RuntimeException)
{
    uno::Reference< lang::XUnoTunnel > xTunnel(rIdentifier, uno::UNO_QUERY);
    return xTunnel.is()
           && xTunnel->getSomething(uno::Sequence< sal_Int8 >(m_aUUID.
                                                                  getData(),
                                                              UUID::LENGTH))
                  == 1;
}

//============================================================================
bool Connection::isLocalContent(uno::Reference< star::ucb::XContent > const &
                                    rContent) const
    throw (uno::RuntimeException)
{
    uno::Reference< lang::XUnoTunnel > xTunnel(rContent, uno::UNO_QUERY);
    return xTunnel.is()
           && xTunnel->getSomething(uno::Sequence< sal_Int8 >(m_aUUID.
                                                                  getData(),
                                                              UUID::LENGTH))
                  == 1;
}

//============================================================================
uno::Reference< star::ucb::XContent >
Connection::getLocalContent(
    uno::Reference< star::ucb::XContentIdentifier > const & rLocalIdentifier,
    uno::Reference< star::ucb::XContentIdentifier > const & rRemoteIdentifier)
    throw (connection::NoConnectException,
           connection::ConnectionSetupException,
           lang::IllegalArgumentException,
           star::ucb::IllegalIdentifierException, uno::RuntimeException)
{
    return Content::create(m_xFactory, this, rLocalIdentifier,
                           getRemoteContent(rRemoteIdentifier));
}

//============================================================================
uno::Reference< star::ucb::XContent >
Connection::getLocalContent(
    uno::Reference< star::ucb::XContentIdentifier > const & rLocalIdentifier,
    uno::Reference< star::ucb::XContent > const & rRemoteContent)
    throw (uno::RuntimeException)
{
    return
        Content::create(m_xFactory, this, rLocalIdentifier, rRemoteContent);
}

//============================================================================
uno::Reference< star::ucb::XContent >
Connection::getRemoteContent(
    uno::Reference< star::ucb::XContentIdentifier > const & rRemoteIdentifier)
    throw (connection::NoConnectException,
           connection::ConnectionSetupException,
           lang::IllegalArgumentException,
           star::ucb::IllegalIdentifierException, uno::RuntimeException)
{
    return getRemoteProvider()->queryContent(rRemoteIdentifier);
}

#if defined UCB_RAP_OFFLINE
//============================================================================
void Connection::setOfflineProvider() throw (offline::StorageError)
{
    if (!m_xOfflineProvider.is())
        m_xOfflineProvider = new offline::Provider(m_xFactory, getStorage());
    m_xRemoteProvider = 0;
}

//============================================================================
void Connection::clearOfflineProvider()
{
    m_xOfflineProvider = 0;
    m_xRemoteProvider = 0;
}
#endif // UCB_RAP_OFFLINE

//============================================================================
Connection::Connection(uno::Reference< lang::XMultiServiceFactory > const &
                           rTheFactory,
                       rtl::Reference< ConnectionMap > const &
                           rTheConnectionMap,
                       rtl::OUString const & rTheRemoteProviderURL,
                       UUIDSupplier & rUUIDSupplier):
    m_xFactory(rTheFactory),
    m_xConnectionMap(rTheConnectionMap),
    m_aRemoteProviderURL(rTheRemoteProviderURL),
    m_nRefCount(0),
    m_aUUID(rUUIDSupplier),
    m_nLocalityFactor(0),
    m_bOfflineMode(false)
{
    OSL_ASSERT(m_xFactory.is() && m_xConnectionMap.is());

    // Create m_aConnectionData and m_aLocalURIPrefix from
    // m_aRemoteProviderURL.  If m_aRemoteProviderURL (which must be canonic)
    // is of the form
    //
    //   "uno:" connection ";" protocol ";UCB.Factory"
    //
    // then m_aConnectionData will be of the form
    //
    //   connection
    //
    // and m_aLocalURIPrefix will be of the form
    //
    //   "vnd.sun.star.ucb:" connection ";"
    OSL_ASSERT(m_aRemoteProviderURL.
                       compareToAscii(RTL_CONSTASCII_STRINGPARAM("uno:"))
                   == 0);
    sal_Int32 nDelim
        = m_aRemoteProviderURL.indexOf(';', RTL_CONSTASCII_LENGTH("uno:"));
    OSL_ASSERT(nDelim > 0);
    m_aConnectionData
        = m_aRemoteProviderURL.copy(RTL_CONSTASCII_LENGTH("uno:"),
                                    nDelim - RTL_CONSTASCII_LENGTH("uno:"));
    rtl::OUStringBuffer aPrefix;
    aPrefix.appendAscii(RTL_CONSTASCII_STRINGPARAM("vnd.sun.star.ucb:"));
    aPrefix.append(m_aConnectionData);
    aPrefix.append(sal_Unicode(';'));
    m_aLocalURIPrefix = aPrefix.makeStringAndClear();
    {
        rtl::OUStringBuffer aTemplate;
        aTemplate.append(sal_Unicode('"'));
        aTemplate.append(m_aLocalURIPrefix);
        aTemplate.appendAscii(RTL_CONSTASCII_STRINGPARAM("\"(.*)->\\1"));
        m_aLocalToRemoteURIs.add(aTemplate.makeStringAndClear(), true, false);
    }

    {
        rtl::OUStringBuffer aTemplate;
        aTemplate.appendAscii(RTL_CONSTASCII_STRINGPARAM("(.*)->\""));
        aTemplate.append(m_aLocalURIPrefix);
        aTemplate.appendAscii(RTL_CONSTASCII_STRINGPARAM("\"\\1"));
        m_aRemoteToLocalURIs.add(aTemplate.makeStringAndClear(), true, false);
    }

    {
        rtl::OUStringBuffer aTemplate;
        aTemplate.append(sal_Unicode('"'));
        aTemplate.append(m_aLocalURIPrefix);
        aTemplate.appendAscii(RTL_CONSTASCII_STRINGPARAM("\".*"));
        m_aRemoteToLocalURIs.add(aTemplate.makeStringAndClear(), true, false);
    }
}

//============================================================================
Connection::~Connection() throw ()
{
    if (m_xChangeListener.is())
        m_xChangeListener->clear();
}

//============================================================================
// virtual
uno::Any SAL_CALL Connection::queryInterface(uno::Type const & rType)
    throw (uno::RuntimeException)
{
    return cppu::queryInterface(
               rType,
               static_cast< uno::XInterface * >(
                   static_cast< star::ucb::XContentProvider * >(this)),
               static_cast< star::ucb::XContentProvider * >(this),
               static_cast< star::ucb::XContentIdentifierFactory * >(this),
               static_cast< star::ucb::XCommandProcessor * >(this),
               static_cast< star::ucb::XFileIdentifierConverter * >(this));
}

//============================================================================
// virtual
void SAL_CALL Connection::acquire() throw ()
{
    osl_incrementInterlockedCount(&m_nRefCount);
}

//============================================================================
// virtual
void SAL_CALL Connection::release() throw ()
{
    m_xConnectionMap->releaseConnection(this);
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContent > SAL_CALL
Connection::queryContent(
    uno::Reference< star::ucb::XContentIdentifier > const & rIdentifier)
    throw (star::ucb::IllegalIdentifierException, uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    try
    {
        return getLocalContent(normalizeLocalIdentifier(rIdentifier),
                               mapToRemoteIdentifier(rIdentifier));
    }
    catch (connection::NoConnectException const &)
    {
        return 0;
    }
    catch (connection::ConnectionSetupException const &)
    {
        return 0;
    }
    catch (lang::IllegalArgumentException const &)
    {
        throw star::ucb::IllegalIdentifierException();
    }
}

//============================================================================
// virtual
sal_Int32 SAL_CALL
Connection::compareContentIds(
    uno::Reference< star::ucb::XContentIdentifier > const & rId1,
    uno::Reference< star::ucb::XContentIdentifier > const & rId2)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    try
    {
        return getRemoteProvider()->
                   compareContentIds(mapToRemoteIdentifier(rId1),
                                     mapToRemoteIdentifier(rId2));
    }
    catch (connection::NoConnectException const &)
    {}
    catch (connection::ConnectionSetupException const &)
    {}
    catch (lang::IllegalArgumentException const &)
    {}

    rtl::OUString aURI1;
    if (rId1.is())
        aURI1 = rId1->getContentIdentifier();
    rtl::OUString aURI2;
    if (rId2.is())
        aURI2 = rId2->getContentIdentifier();
    return aURI1.compareTo(aURI2);
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContentIdentifier > SAL_CALL
Connection::createContentIdentifier(rtl::OUString const & rContentId)
    throw (uno::RuntimeException)
{
    return new ::ucb::ContentIdentifier(rContentId);
}

//============================================================================
// virtual
sal_Int32 SAL_CALL Connection::createCommandIdentifier()
    throw (uno::RuntimeException)
{
    return 0; //TODO!
}

//============================================================================
// virutal
uno::Any SAL_CALL
Connection::execute(
    star::ucb::Command const & rCommand,
    sal_Int32,
    uno::Reference< star::ucb::XCommandEnvironment > const &)
    throw (uno::Exception,
           star::ucb::CommandAbortedException,
           uno::RuntimeException)
{
    if (rCommand.Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("synchronize")))
    {
#if defined UCB_RAP_OFFLINE
        star::sync::SynchronizeCommandArgument aArgument;
        if (!(rCommand.Argument >>= aArgument))
            throw uno::Exception(); //TODO!

        osl::MutexGuard aGuard(m_aMutex);

        try
        {
            setOfflineProvider();
        }
        catch (offline::StorageError &)
        {
            throw uno::Exception(); //TODO!
        }
        m_xOfflineProvider->synchronize(aArgument.ClientId,
                                        m_aConnectionData);

        if (aArgument.Online)
            clearOfflineProvider();
#endif // UCB_RAP_OFFLINE

        return uno::Any();
    }

    throw uno::Exception(); //TODO!
}

//============================================================================
// virtual
void SAL_CALL Connection::abort(sal_Int32 nCommandId)
    throw (uno::RuntimeException)
{
    //TODO!
}

//============================================================================
// virtual
sal_Int32 SAL_CALL
Connection::getFileProviderLocality(rtl::OUString const & rBaseURL)
    throw (uno::RuntimeException)
{
    uno::Reference< star::ucb::XContentProvider > xProvider;
    {
        osl::MutexGuard aGuard(m_aMutex);
        try
        {
            xProvider = getRemoteProvider();
        }
        catch (connection::NoConnectException const &) {}
        catch (connection::ConnectionSetupException const &) {}
        catch (lang::IllegalArgumentException const &) {}
    }

    rtl::OUString aRemoteBaseURL(mapToRemoteURI(rBaseURL));
    uno::Reference< star::ucb::XContentProviderManager >
        xManager(xProvider, uno::UNO_QUERY);
    if (xManager.is())
        xProvider = xManager->queryContentProvider(aRemoteBaseURL);

    sal_Int32 nLocality = -1;
    uno::Reference< star::ucb::XFileIdentifierConverter >
        xConverter(xProvider, uno::UNO_QUERY);
    if (xConverter.is())
        nLocality = xConverter->getFileProviderLocality(aRemoteBaseURL);
    return nLocality >= 0 && nLocality <= 10 ?
               nLocality * m_nLocalityFactor / 100 : nLocality;
}

//============================================================================
// virtual
rtl::OUString SAL_CALL
Connection::getFileURLFromSystemPath(rtl::OUString const & rBaseURL,
                                     rtl::OUString const & rSystemPath)
    throw (uno::RuntimeException)
{
    uno::Reference< star::ucb::XContentProvider > xProvider;
    {
        osl::MutexGuard aGuard(m_aMutex);
        try
        {
            xProvider = getRemoteProvider();
        }
        catch (connection::NoConnectException const &) {}
        catch (connection::ConnectionSetupException const &) {}
        catch (lang::IllegalArgumentException const &) {}
    }

    uno::Reference< star::ucb::XContentProviderManager >
        xManager(xProvider, uno::UNO_QUERY);
    if (xManager.is())
        return mapToLocalURI(::ucb::getFileURLFromSystemPath(xManager,
                                                             mapToRemoteURI(
                                                                 rBaseURL),
                                                             rSystemPath));

    uno::Reference< star::ucb::XFileIdentifierConverter >
        xConverter(xProvider, uno::UNO_QUERY);
    if (xConverter.is())
        return mapToLocalURI(xConverter->
                                 getFileURLFromSystemPath(mapToRemoteURI(
                                                              rBaseURL),
                                                          rSystemPath));

    return rtl::OUString();
}

//============================================================================
// virtual
rtl::OUString SAL_CALL
Connection::getSystemPathFromFileURL(rtl::OUString const & rURL)
    throw (uno::RuntimeException)
{
    uno::Reference< star::ucb::XContentProvider > xProvider;
    {
        osl::MutexGuard aGuard(m_aMutex);
        try
        {
            xProvider = getRemoteProvider();
        }
        catch (connection::NoConnectException const &) {}
        catch (connection::ConnectionSetupException const &) {}
        catch (lang::IllegalArgumentException const &) {}
    }

    uno::Reference< star::ucb::XContentProviderManager >
        xManager(xProvider, uno::UNO_QUERY);
    if (xManager.is())
        return ::ucb::getSystemPathFromFileURL(xManager,
                                               mapToRemoteURI(rURL));

    uno::Reference< star::ucb::XFileIdentifierConverter >
        xConverter(xProvider, uno::UNO_QUERY);
    if (xConverter.is())
        return xConverter->getSystemPathFromFileURL(mapToRemoteURI(rURL));

    return rtl::OUString();
}

//============================================================================
bool Connection::addLocalURITemplate(rtl::OUString const & rTemplate,
                                     bool bOverwrite)
    throw (lang::IllegalArgumentException, uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    //@@@ no commit-or-rollback semantics:
    rtl::OUString aReverse;
    bool bAdded
        = m_aLocalToRemoteURIs.add(rTemplate, true, bOverwrite, &aReverse);
    if (bAdded)
        m_aRemoteToLocalURIs.add(aReverse, true, true);
    return bAdded;
}

//============================================================================
bool Connection::removeLocalURITemplate(rtl::OUString const & rTemplate)
    throw (lang::IllegalArgumentException, uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    rtl::OUString aReverse;
    RegexpToBoolMap::iterator
        aIt(m_aLocalToRemoteURIs.find(rTemplate, &aReverse));
    if (aIt == m_aLocalToRemoteURIs.end())
        return false;

    m_aLocalToRemoteURIs.erase(aIt);
    aIt = m_aRemoteToLocalURIs.find(rTemplate);
    if (aIt != m_aRemoteToLocalURIs.end())
        m_aRemoteToLocalURIs.erase(aIt);
    return true;
}

//============================================================================
rtl::OUString Connection::mapToLocalURI(rtl::OUString const & rRemoteURI)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    if (rRemoteURI.getLength() != 0)
    {
        rtl::OUString aLocalURI;
        bool bTranslated;
        if (m_aRemoteToLocalURIs.map(rRemoteURI, &aLocalURI, &bTranslated)
            && bTranslated)
            return aLocalURI;
    }
    return rRemoteURI;
}

//============================================================================
uno::Reference< star::ucb::XContentIdentifier >
Connection::mapToLocalIdentifier(
    uno::Reference< star::ucb::XContentIdentifier > const & rRemoteIdentifier)
    throw (uno::RuntimeException)
{
    if (!rRemoteIdentifier.is())
        return rRemoteIdentifier;

    rtl::OUString aURI(rRemoteIdentifier->getContentIdentifier());
    if (aURI.getLength())
    {
        osl::MutexGuard aGuard(m_aMutex);
        m_aRemoteToLocalURIs.map(aURI, &aURI);
    }

    return new LocalContentIdentifier(this, aURI, rRemoteIdentifier);
}

//============================================================================
uno::Reference< star::ucb::XContent >
Connection::mapToLocalContent(uno::Reference< star::ucb::XContent > const &
                                  rRemoteContent)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    uno::Reference< star::ucb::XContent > xLocalContent;
    if (rRemoteContent.is())
    {
        uno::Reference< star::ucb::XContentIdentifier >
            xRemoteIdentifier(rRemoteContent->getIdentifier());
        if (xRemoteIdentifier.is())
        {
            rtl::OUString aURI(xRemoteIdentifier->getContentIdentifier());
            if (aURI.getLength() > 0)
                m_aRemoteToLocalURIs.map(aURI, &aURI);

            xLocalContent
                = getLocalContent(new LocalContentIdentifier(
                                          this, aURI, xRemoteIdentifier),
                                  rRemoteContent);
        }
    }
    return xLocalContent.is() ? xLocalContent : rRemoteContent;
}

//============================================================================
rtl::OUString Connection::mapToRemoteURI(rtl::OUString const & rLocalURI)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    if (rLocalURI.getLength() != 0)
    {
        rtl::OUString aRemoteURI;
        bool bTranslated;
        if (m_aLocalToRemoteURIs.map(rLocalURI, &aRemoteURI, &bTranslated)
            && bTranslated)
            return aRemoteURI;
    }
    return rLocalURI;
}

//============================================================================
uno::Reference< star::ucb::XContent >
Connection::mapToRemoteContent(uno::Reference< star::ucb::XContent > const &
                                   rContent)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);

    uno::Reference< star::ucb::XContent > xRemoteContent(rContent);
    if (isLocalContent(rContent))
        try
        {
            xRemoteContent
                = getRemoteContent(mapToRemoteIdentifier(
                                       rContent->getIdentifier()));
        }
        catch (connection::NoConnectException const &) {}
        catch (connection::ConnectionSetupException const &) {}
        catch (lang::IllegalArgumentException const &) {}
        catch (star::ucb::IllegalIdentifierException const &) {}
    return xRemoteContent;
}

//============================================================================
bool Connection::mapsToThisConnection(rtl::OUString const & rLocalURI) const
    throw (uno::RuntimeException)
{
    return (m_xConnectionMap->
                        getProvider()->
                            findConnection(new ::ucb::ContentIdentifier(
                                                   rLocalURI))
                    == this)
               != false;
}

//============================================================================
star::ucb::InteractiveAugmentedIOException
Connection::mapToLocalException(star::ucb::InteractiveAugmentedIOException
                                    const & rException)
    throw (uno::RuntimeException)
{
    rtl::OUString aURL;
    if (rException.Arguments.getLength() == 1 
        && (rException.Arguments[0] >>= aURL))
    {
        uno::Any aLocalURI = uno::makeAny(mapToLocalURI(aURL));
        return star::ucb::InteractiveAugmentedIOException(
                   rException.Message,
                   rException.Context,
                   rException.Classification,
                   rException.Code,
                   uno::Sequence< uno::Any >(&aLocalURI, 1));
    }
    return rException;
}

#if defined UCB_RAP_OFFLINE
//============================================================================
void Connection::setOfflineMode(bool bMode) throw (offline::StorageError)
{
    osl::MutexGuard aGuard(m_aMutex);
    m_bOfflineMode = bMode;
    if (m_bOfflineMode && getStorage()->isOffline())
        setOfflineProvider();
}

//============================================================================
rtl::Reference< offline::Storage > Connection::getStorage()
    throw (offline::StorageError)
{
    if (!m_xStorage.is())
    {
        osl::MutexGuard aGuard(m_aMutex);
        m_xStorage = new offline::Storage(m_xFactory);
    }
    return m_xStorage;
}
#endif // UCB_RAP_OFFLINE
