/*************************************************************************
 *
 *  $RCSfile: frmfmt.hxx,v $
 *
 *  $Revision: 1.3.326.1 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/16 14:13:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _FRMFMT_HXX
#define _FRMFMT_HXX

#ifndef _FORMAT_HXX
#include <format.hxx>
#endif

// --> OD 2004-10-11 #118082#
const sal_Int16 cPositionInHoriL2R = 1;
const sal_Int16 cPositionInLayoutDirOfAnchor = 2;
// <--

class SwDrawContact;
class SwFlyFrm;
class Graphic;
class Point;
class ImageMap;
class IMapObject;
class SwRect;
class SwContact;
class SdrObject;

class SwFrmFmt: public SwFmt
{
	friend class SwDoc;
	friend class SwPageDesc;	//darf den protected CTor rufen.
	friend class SwSwgReader;	// der SW2-Reader auch!
	friend class Sw3IoImp;		// der SW3-Reader auch!

protected:
	SwFrmFmt( SwAttrPool& rPool, const sal_Char* pFmtNm,
				SwFrmFmt *pDrvdFrm, USHORT nFmtWhich = RES_FRMFMT,
				const USHORT* pWhichRange = 0 )
	  	: SwFmt( rPool, pFmtNm, (pWhichRange ? pWhichRange : aFrmFmtSetRange),
				pDrvdFrm, nFmtWhich )
	{}

	SwFrmFmt( SwAttrPool& rPool, const String &rFmtNm,
				SwFrmFmt *pDrvdFrm, USHORT nFmtWhich = RES_FRMFMT,
				const USHORT* pWhichRange = 0 )
	  	: SwFmt( rPool, rFmtNm, (pWhichRange ? pWhichRange : aFrmFmtSetRange),
				pDrvdFrm, nFmtWhich )
	{}

public:
	TYPEINFO();		//Bereits in Basisklasse Client drin.

	//Vernichtet alle Frms in aDepend (Frms werden per PTR_CAST erkannt).
	virtual void DelFrms();

	//Erzeugt die Ansichten
	virtual void MakeFrms();

	virtual Graphic MakeGraphic( ImageMap* pMap = NULL );

	virtual void Modify( SfxPoolItem* pOldValue, SfxPoolItem* pNewValue );

	// returnt das IMapObject, das an dem Format (Fly), in der ImageMap
	// an der Point Position definiert ist.
	// 	rPoint - teste auf der DocPosition
	//	pFly - optionaler FlyFrame, falls der schon bekannt ist.
	IMapObject* GetIMapObject( const Point& rPoint,
								const SwFlyFrm *pFly = 0 ) const;

	// Gibt die tatsaechlche Groesse des Frames zurueck bzw. ein leeres
	// Rechteck, wenn kein Layout existiert. Wird pPoint angegeben, dann
	// wird der am dichtesten liegende Frame gesucht.
	SwRect FindLayoutRect( const BOOL bPrtArea = FALSE,
							const Point* pPoint = 0,
							const BOOL bCalcFrm = FALSE ) const;

	// Sucht das SdrObject. Der SdrObjUserCall ist Client vom Format.
	// Der UserCall kennt sein SdrObject.
		  SwContact *FindContactObj();
	const SwContact *FindContactObj() const
		{ return ((SwFrmFmt*)this)->FindContactObj(); }

	// returns the SdrObject, that ist connected to the ContactObject.
	// Only DrawFrmFmts are connected to the "real SdrObject". FlyFrmFmts
	// are connected to a Master and all FlyFrms has the "real SdrObject".
	// "Real SdrObject" has position and a Z-order.
		  SdrObject *FindSdrObject();
	const SdrObject *FindSdrObject() const
		{ return ((SwFrmFmt*)this)->FindSdrObject(); }

		  SdrObject *FindRealSdrObject();
	const SdrObject *FindRealSdrObject() const
		{ return ((SwFrmFmt*)this)->FindRealSdrObject(); }

	BOOL IsLowerOf( const SwFrmFmt& rFmt ) const;

    // --> OD 2004-10-11 #118082#
    virtual sal_Int16 GetPositionLayoutDir() const;
    virtual void SetPositionLayoutDir( const sal_Int16 _nPositionLayoutDir );
    // <--

	DECL_FIXEDMEMPOOL_NEWDEL(SwFrmFmt)
};

//Das FlyFrame-Format ------------------------------

class SwFlyFrmFmt: public SwFrmFmt
{
	friend class SwDoc;

	//Beide nicht vorhanden.
	SwFlyFrmFmt( const SwFlyFrmFmt &rCpy );
	SwFlyFrmFmt &operator=( const SwFlyFrmFmt &rCpy );

protected:
	SwFlyFrmFmt( SwAttrPool& rPool, const sal_Char* pFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, pFmtNm, pDrvdFrm, RES_FLYFRMFMT )
	{}
	SwFlyFrmFmt( SwAttrPool& rPool, const String &rFmtNm,
					SwFrmFmt *pDrvdFrm )
		: SwFrmFmt( rPool, rFmtNm, pDrvdFrm, RES_FLYFRMFMT )
	{}

public:
	TYPEINFO();
	~SwFlyFrmFmt();

	//Erzeugt die Ansichten
	virtual void MakeFrms();

	SwFlyFrm* GetFrm( const Point* pDocPos = 0,
						const BOOL bCalcFrm = FALSE ) const;

	virtual Graphic MakeGraphic( ImageMap* pMap = NULL );

	virtual BOOL GetInfo( SfxPoolItem& rInfo ) const;

    /** SwFlyFrmFmt::IsBackgroundTransparent - for #99657#

        OD 22.08.2002 - overloading virtual method and its default implementation,
        because format of fly frame provides transparent backgrounds.
        Method determines, if background of fly frame is transparent.

        @author OD

        @return true, if background color is transparent, but not "no fill"
        or a existing background graphic is transparent.
    */
    virtual const sal_Bool IsBackgroundTransparent() const;

    /** SwFlyFrmFmt::IsBackgroundBrushInherited - for #103898#

        OD 08.10.2002 - method to determine, if the brush for drawing the
        background is "inherited" from its parent/grandparent.
        This is the case, if no background graphic is set and the background
        color is "no fill"/"auto fill"

        @author OD

        @return true, if background brush is "inherited" from parent/grandparent
    */
    const sal_Bool IsBackgroundBrushInherited() const;

	DECL_FIXEDMEMPOOL_NEWDEL(SwFlyFrmFmt)
};

//Das DrawFrame-Format -----------------------------

class SwDrawFrmFmt: public SwFrmFmt
{
	friend class SwDoc;

    // --> OD 2004-10-11 #118082#
    sal_uInt8 mnPositionLayoutDir;
    // <--

    //Beide nicht vorhanden.
	SwDrawFrmFmt( const SwDrawFrmFmt &rCpy );
	SwDrawFrmFmt &operator=( const SwDrawFrmFmt &rCpy );

protected:
	SwDrawFrmFmt( SwAttrPool& rPool, const sal_Char* pFmtNm,
					SwFrmFmt *pDrvdFrm )
        : SwFrmFmt( rPool, pFmtNm, pDrvdFrm, RES_DRAWFRMFMT ),
          // --> OD 2004-10-11 #118082#
          mnPositionLayoutDir( cPositionInHoriL2R )
          // <--
	{}
	SwDrawFrmFmt( SwAttrPool& rPool, const String &rFmtNm,
					SwFrmFmt *pDrvdFrm )
        : SwFrmFmt( rPool, rFmtNm, pDrvdFrm, RES_DRAWFRMFMT ),
          // --> OD 2004-10-11 #118082#
          mnPositionLayoutDir( cPositionInHoriL2R )
          // <--
	{}

public:
	TYPEINFO();
	~SwDrawFrmFmt();

	//DrawObjecte werden aus den Arrays am Layout entfernt. Die DrawObjecte
	//werden als geloescht gekennzeichnet.
	virtual void DelFrms();

	//Anmelden der DrawObjecte in den Arrays am Layout. Loeschkennzeichen
	//werden zurueckgesetzt.
	virtual void MakeFrms();

	virtual Graphic MakeGraphic( ImageMap* pMap = NULL );

    // --> OD 2004-10-11 #118082#
    virtual sal_Int16 GetPositionLayoutDir() const;
    virtual void SetPositionLayoutDir( const sal_Int16 _nPositionLayoutDir );
    // <--
	DECL_FIXEDMEMPOOL_NEWDEL(SwDrawFrmFmt);
};

#endif
