/*************************************************************************
 *
 *  $RCSfile: SwRedlineModeGuard.hxx,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/10/12 09:34:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SWREDLINEMODEGUARD_HXX
#define _SWREDLINEMODEGUARD_HXX

#ifndef _REDLENUM_HXX
#include "redenum.hxx"
#endif

#ifndef _DOC_HXX
#include "doc.hxx"
#endif


/** 
 * Preserve or switch the RedlineMode on the given document.
 * Either SetRedlineMode or SetRedlineMode_intern may be used,
 * depending on whether redlines should be copied or not.
 *
 * The mode changes are performed in the constructor/destructor making
 * it exception save, i.e. it uses the
 * initialization-is-resource-acquisition idiom.
 */
class SwRedlineModeGuard
{
    typedef void (SwDoc::*RedlineModeFunction)(sal_uInt16);

    SwDoc& mrDoc;
    SwRedlineMode meOldRedlineMode;
    RedlineModeFunction mpRedlineModeFunction;


public:

    inline SwRedlineModeGuard( 
        SwDoc& rDoc,   /// preserve mode of this document
        RedlineModeFunction pRedlineModeFunction =
            &SwDoc::SetRedlineMode_intern );

    inline SwRedlineModeGuard( 
        SwDoc& rDoc,                      /// change mode of this document
        SwRedlineMode eNewRedlineMode,    /// new redline mode
        RedlineModeFunction pRedlineModeFunction = /// switch function
            &SwDoc::SetRedlineMode_intern,
        SwRedlineMode eRedlineModeMask  = /// change only bits set in this mask
            static_cast<SwRedlineMode> ( REDLINE_ON | REDLINE_IGNORE ) );

    inline ~SwRedlineModeGuard();
};

SwRedlineModeGuard::SwRedlineModeGuard( 
        SwDoc& rDoc,
        RedlineModeFunction pRedlineModeFunction )
    : mrDoc( rDoc ),
      mpRedlineModeFunction( pRedlineModeFunction ),
      meOldRedlineMode( rDoc.GetRedlineMode() )
{
}

SwRedlineModeGuard::SwRedlineModeGuard( 
    SwDoc& rDoc, 
    SwRedlineMode eNewRedlineMode,
    RedlineModeFunction pRedlineModeFunction,
    SwRedlineMode eRedlineModeMask ) 
    : mrDoc( rDoc ),
      mpRedlineModeFunction( pRedlineModeFunction ),
      meOldRedlineMode( rDoc.GetRedlineMode() )
{
    (mrDoc.*mpRedlineModeFunction)( ( meOldRedlineMode & ~eRedlineModeMask ) |
                                    ( eNewRedlineMode & eRedlineModeMask ) );
}

SwRedlineModeGuard::~SwRedlineModeGuard()
{
    (mrDoc.*mpRedlineModeFunction)( meOldRedlineMode );
}

#endif
