/*************************************************************************
 *
 *  $RCSfile: linkdlg.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: jl $ $Date: 2001/07/31 08:13:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LINKDLG_HXX
#define _LINKDLG_HXX

#ifndef _SO2REF_HXX
#include <so2ref.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

class SvTabListBox;
class Window;
class RadioButton;
class PushButton;
class Window;


namespace so3 {

/********************** SvUpdateLinksDialog ******************************
*************************************************************************/
class SvBaseLinksDlg;
class SvLinkManager;
class SvBaseLink;

class SvBaseLinksDialog
{
	SvBaseLinksDlg* pDlg;
	SvLinkManager*	pLinkMgr;
	BOOL 			bHtmlMode;
#if _SOLAR__PRIVATE
	DECL_LINK( LinksSelectHdl, SvTabListBox * );
	DECL_LINK( LinksDoubleClickHdl, SvTabListBox * );
	DECL_LINK( AutomaticClickHdl, RadioButton * );
	DECL_LINK( ManualClickHdl, RadioButton * );
	DECL_LINK( UpdateNowClickHdl, PushButton * );
	DECL_LINK( OpenSourceClickHdl, PushButton * );
	DECL_LINK( ChangeSourceClickHdl, PushButton * );
	DECL_LINK( BreakLinkClickHdl, PushButton * );
	DECL_LINK( UpdateWaitingHdl, Timer * );
	SvBaseLink* GetSelEntry( USHORT* pPos );
	String ImplGetStateStr( const SvBaseLink& );
	void SetType( SvBaseLink& rLink, USHORT nPos, USHORT nType );
    void InsertEntry( const SvBaseLink& rLink, USHORT nPos = LISTBOX_APPEND, sal_Bool bSelect = sal_False);
#endif
public:
	SvBaseLinksDialog( Window * pParent, SvLinkManager*, BOOL bHtml = FALSE );
	~SvBaseLinksDialog();

	void Execute();

	void SetManager( SvLinkManager* );
	void SetActLink( SvBaseLink * pLink );
};

}

#endif // _LINKDLG_HXX
