/*************************************************************************
 *
 *  $RCSfile: fuslshw2.cxx,v $
 *
 *  $Revision: 1.22.22.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 14:51:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vector>

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx> //autogen
#endif

#ifndef _E3D_SCENE3D_HXX

#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif

#define protected public
#include <svx/scene3d.hxx>
#undef protected
#define protected protected
#endif

#include "showview.hxx"
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SVX_FMGLOB_HXX //autogen
#include <svx/fmglob.hxx>
#endif
#ifndef _SVX_XFLHTIT_HXX //autogen
#include <svx/xflhtit.hxx>
#endif
#ifndef _SVX_XHATCH_HXX //autogen
#include <svx/xhatch.hxx>
#endif
#ifndef _SVX_XGRAD_HXX //autogen
#include <svx/xgrad.hxx>
#endif
#ifndef _SVX_XFLHTIT_HXX //autogen
#include <svx/xflhtit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif
#ifndef _SVX_XLNTRIT_HXX //autogen
#include <svx/xlntrit.hxx>
#endif
#ifndef _SVX_XFLTRIT_HXX //autogen
#include <svx/xfltrit.hxx>
#endif
#ifndef _SVX_XFLGRIT_HXX //autogen
#include <svx/xflgrit.hxx>
#endif
#ifndef _SVX_XFLFTRIT_HXX //autogen
#include <svx/xflftrit.hxx>
#endif
#ifndef _XOUTX_HXX //autogen
#include <svx/xoutx.hxx>
#endif
#ifndef _SVDOGRP_HXX //autogen
#include <svx/svdogrp.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include <svx/svdotext.hxx>
#endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <svx/svdoole2.hxx>
#endif
#ifndef _SVDOUNO_HXX //autogen
#include <svx/svdouno.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif
#ifndef _EDITSTAT_HXX //autogen
#include <svx/editstat.hxx>
#endif
#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
#ifndef _SFXSMPLHINT_HXX //autogen
#include <svtools/smplhint.hxx>
#endif
#ifndef _MyEDITENG_HXX
#include <svx/editeng.hxx>
#endif
#include <svx/bulitem.hxx>
#include <svx/globl3d.hxx>

#define FUSLIDESHOW_INTERN

#include "fuslshow.hxx"
#include "eetext.hxx"           // fuer ITEMID_COLOR
#include "sdresid.hxx"
#include "res_bmp.hrc"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "mover.hxx"
#include "fader.hxx"
#include "anminfo.hxx"
#include "glob.hrc"
#include "frmview.hxx"
#include "viewshel.hxx"
#include "docshell.hxx"
#include "outlinfo.hxx"
#include "cusshow.hxx"
#include "sdoutl.hxx"

#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif

using namespace ::com::sun::star;
// -----------
// - Defines -
// -----------

#define ITEMVALUE(ItemSet,Id,Cast)	((const Cast&)(ItemSet).Get(Id)).GetValue()

// ----------------
// - SdChangedObj -
// ----------------

void SdChangedObj::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType, const SfxHint& rHint, const TypeId& rHintType )
{
	SfxSimpleHint*	pSimple = PTR_CAST( SfxSimpleHint,&rHint );
	const ULONG		nId = !pSimple ? 0 : pSimple->GetId();

	if( SFX_HINT_DYING == nId )
		bDeleted = TRUE;
}

// ---------------
// - FuSlideShow -
// ---------------

void FuSlideShow::FindSpecialObjects( const SdrPage* pPage, BOOL& rEnableOutput )
{
	for ( ULONG nObj = 0UL, nObjCount = pPage->GetObjCount(); nObj < nObjCount; nObj++ )
	{
		SdrObject* pObj = pPage->GetObj( nObj );

		if( pPage->IsMasterPage() &&
			( ( pObj->GetObjInventor() == SdrInventor &&
				( pObj->GetObjIdentifier() == OBJ_TITLETEXT || pObj->GetObjIdentifier() == OBJ_OUTLINETEXT ) ) ||
			  ( (SdPage*) pPage )->GetPresObj( PRESOBJ_BACKGROUND ) == pObj ) )
		{
			continue;
		}

		if( pObj->IsInserted() )
		{
			const SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pObj );
			const BOOL				bAnimGrfObj = OBJIS_GRAFANIM( pObj );
			const BOOL				bAnimTxtObj = OBJIS_TEXTANIM( pObj );
			const BOOL				bUnoObj = pObj->ISA( SdrUnoObj ) && ( FmFormInventor == pObj->GetObjInventor() );

			if ( pInfo )
			{
				// innerhalb der Show moven wir das am Pfad zu bewegende Objekt
				// gegebenenfalls, damit Repaints das Objekt an der richtigen
				// Stelle zeichen
				if( eAnimationMode == ANIMATIONMODE_SHOW &&
					pInfo->bActive &&
					pInfo->eEffect == presentation::AnimationEffect_PATH &&
					pInfo->pPathObj )
				{
					const Point			aCenter( pObj->GetLogicRect().Center() );
					const XPolyPolygon& rXPolyPoly = pInfo->pPathObj->GetPathPoly();
					const XPolygon&		rXPoly = rXPolyPoly.GetObject( rXPolyPoly.Count() - 1 );
					const Point			aNewCenter( rXPoly[ rXPoly.GetPointCount() - 1 ] );
					const Size			aMove( aNewCenter.X() - aCenter.X(), aNewCenter.Y() - aCenter.Y() );

					if( aMove.Width() && aMove.Height() )
					{
						SdChangedObj* pChg = new SdChangedObj;

						pChg->pObject = pObj;
						pChg->aMove = aMove;
						pChg->bPosChanged = TRUE;
						aChangedList.Insert( pChg, LIST_APPEND );
						pObj->NbcMove( aMove );
						pObj->AddListener( *pChg );
					}
				}

				if ( pInfo->bActive &&
					 ( ( pInfo->eEffect != presentation::AnimationEffect_NONE ) || ( pInfo->eEffect == presentation::AnimationEffect_NONE && pInfo->bIsMovie) ) ||
					 ( pInfo->eTextEffect != presentation::AnimationEffect_NONE && !bAnimTxtObj ) )
				{
					pNextAnmList->Insert( pObj, LIST_APPEND );
					aAnimObjsBoundRect.Union( pObj->GetBoundRect() );
				}

				// gibt es initial sichtbare Objekte, die verschwinden koennen?
				if (!bIVDsFound && ( pInfo->eClickAction == presentation::ClickAction_INVISIBLE || pInfo->eClickAction == presentation::ClickAction_VANISH ) &&
					( !pInfo->bActive || ( pInfo->eEffect == presentation::AnimationEffect_NONE && !pInfo->bIsMovie ) ) )
				{
					bIVDsFound = TRUE;
				}

				if ( AffectsOwnPage( pObj ) && ( !pInfo->bActive ||
					 ( pInfo->eEffect == presentation::AnimationEffect_NONE && !pInfo->bIsMovie ) ) )
				{
					nVisibleAffectingObjects++;
				}
			}

			// animierte Grafiken, die nicht per Effekt gestartet werden, in
			// einer Liste merken, damit sie nach dem Anzeigen der Seite
			// gestartet werden koennen
			if( bAnimGrfObj )
				( (SdrGrafObj*) pObj )->ResetAnimationLoopCount();

			if( ( bAnimGrfObj || bAnimTxtObj  ) && ( !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) ) )
				pNextAnimGraphs->Insert( pObj, LIST_APPEND );

			if( bUnoObj && ( !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) ) )
				pNextControls->Insert( pObj, LIST_APPEND );

			// auch animierte Grafiken innerhalb von Gruppen sollen
			// gestartet werden
			if ( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRUP )
			{
				SdrObjList*		pSubList = pObj->GetSubList();
				SdrObjListIter	aIter( *pSubList, IM_DEEPWITHGROUPS );

				for( SdrObject* pO = aIter.Next(); pO; pO = aIter.Next() )
				{
					const BOOL bAnimGrfObj = OBJIS_GRAFANIM( pO );
					const BOOL bAnimTxtObj = OBJIS_TEXTANIM( pO );
					const BOOL bUnoObj = pO->ISA( SdrUnoObj ) && ( FmFormInventor == pO->GetObjInventor() );

					if( bAnimGrfObj )
						( (SdrGrafObj*) pO )->ResetAnimationLoopCount();

					if( ( bAnimGrfObj || bAnimTxtObj ) && !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) )
						pNextAnimGraphs->Insert( pO, LIST_APPEND );

					if( bUnoObj && ( !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) ) )
						pNextControls->Insert( pO, LIST_APPEND );
				}
			}

			// transparente Ausgaben, die den Hintergrund brauchen (in diesem Fall vom 3D-Objekt)?
			if( !rEnableOutput && pObj->ISA( E3dScene ) && ( (E3dScene*) pObj )->pSub )
			{
				E3dScene*		pScene = (E3dScene*) pObj;
				SdrObjListIter	a3DIterator( *( pScene->pSub ), IM_DEEPWITHGROUPS );

				while( !rEnableOutput && a3DIterator.IsMore() )
				{
					SdrObject* p3dObj = a3DIterator.Next();

					// Nur darstellbare Objekte bewerten
					if( p3dObj->ISA( E3dCompoundObject ) )
					{
						// Flaechenattribut testen
						const SfxItemSet& rSet = p3dObj->GetItemSet();
						UINT16 nFillTrans = ITEMVALUE(rSet, XATTR_FILLTRANSPARENCE, XFillTransparenceItem);
						if(nFillTrans)
							rEnableOutput = TRUE;

						if( !rEnableOutput )
						{
							// Linienattribut testen
    						UINT16 nLineTransparence = ITEMVALUE( rSet, XATTR_LINETRANSPARENCE, XLineTransparenceItem );
							if( nLineTransparence )
								rEnableOutput = TRUE;
						}
					}
				}
			}
		}
	}

	ResortAnmList( *pNextAnmList );
}

// -----------------------------------------------------------------------------

presentation::FadeEffect FuSlideShow::EffectAToF( presentation::AnimationEffect eEffect )
{
	switch( eEffect )
	{
		case presentation::AnimationEffect_NONE:
		case presentation::AnimationEffect_HIDE:
		case presentation::AnimationEffect_APPEAR:					return presentation::FadeEffect_NONE;

		case presentation::AnimationEffect_FADE_FROM_LEFT:			return presentation::FadeEffect_FADE_FROM_LEFT;
		case presentation::AnimationEffect_FADE_FROM_UPPERLEFT:		return presentation::FadeEffect_FADE_FROM_UPPERLEFT;
		case presentation::AnimationEffect_FADE_FROM_TOP:			return presentation::FadeEffect_FADE_FROM_TOP;
		case presentation::AnimationEffect_FADE_FROM_UPPERRIGHT:	return presentation::FadeEffect_FADE_FROM_UPPERRIGHT;
		case presentation::AnimationEffect_FADE_FROM_RIGHT:			return presentation::FadeEffect_FADE_FROM_RIGHT;
		case presentation::AnimationEffect_FADE_FROM_LOWERRIGHT:	return presentation::FadeEffect_FADE_FROM_LOWERRIGHT;
		case presentation::AnimationEffect_FADE_FROM_BOTTOM:		return presentation::FadeEffect_FADE_FROM_BOTTOM;
		case presentation::AnimationEffect_FADE_FROM_LOWERLEFT:		return presentation::FadeEffect_FADE_FROM_LOWERLEFT;

		case presentation::AnimationEffect_MOVE_FROM_LEFT:			return presentation::FadeEffect_MOVE_FROM_LEFT;
		case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:		return presentation::FadeEffect_MOVE_FROM_UPPERLEFT;
		case presentation::AnimationEffect_MOVE_FROM_TOP:			return presentation::FadeEffect_MOVE_FROM_TOP;
		case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:	return presentation::FadeEffect_MOVE_FROM_UPPERRIGHT;
		case presentation::AnimationEffect_MOVE_FROM_RIGHT:			return presentation::FadeEffect_MOVE_FROM_RIGHT;
		case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:	return presentation::FadeEffect_MOVE_FROM_LOWERRIGHT;
		case presentation::AnimationEffect_MOVE_FROM_BOTTOM:		return presentation::FadeEffect_MOVE_FROM_BOTTOM;
		case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:		return presentation::FadeEffect_MOVE_FROM_LOWERLEFT;

		case presentation::AnimationEffect_FADE_TO_CENTER:			return presentation::FadeEffect_FADE_TO_CENTER;
		case presentation::AnimationEffect_FADE_FROM_CENTER:		return presentation::FadeEffect_FADE_FROM_CENTER;

		case presentation::AnimationEffect_VERTICAL_STRIPES:		return presentation::FadeEffect_VERTICAL_STRIPES;
		case presentation::AnimationEffect_HORIZONTAL_STRIPES:		return presentation::FadeEffect_HORIZONTAL_STRIPES;

		case presentation::AnimationEffect_VERTICAL_LINES:			return presentation::FadeEffect_VERTICAL_LINES;
		case presentation::AnimationEffect_HORIZONTAL_LINES:		return presentation::FadeEffect_HORIZONTAL_LINES;

		case presentation::AnimationEffect_VERTICAL_CHECKERBOARD:	return presentation::FadeEffect_VERTICAL_CHECKERBOARD;
		case presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD:	return presentation::FadeEffect_HORIZONTAL_CHECKERBOARD;

		case presentation::AnimationEffect_CLOCKWISE:				return presentation::FadeEffect_CLOCKWISE;
		case presentation::AnimationEffect_COUNTERCLOCKWISE:		return presentation::FadeEffect_COUNTERCLOCKWISE;

		case presentation::AnimationEffect_CLOSE_VERTICAL:			return presentation::FadeEffect_CLOSE_VERTICAL;
		case presentation::AnimationEffect_CLOSE_HORIZONTAL:		return presentation::FadeEffect_CLOSE_HORIZONTAL;

		case presentation::AnimationEffect_OPEN_VERTICAL:			return presentation::FadeEffect_OPEN_VERTICAL;
		case presentation::AnimationEffect_OPEN_HORIZONTAL:			return presentation::FadeEffect_OPEN_HORIZONTAL;

		case presentation::AnimationEffect_SPIRALIN_LEFT:			return presentation::FadeEffect_SPIRALIN_LEFT;
		case presentation::AnimationEffect_SPIRALIN_RIGHT:			return presentation::FadeEffect_SPIRALIN_RIGHT;

		case presentation::AnimationEffect_SPIRALOUT_LEFT:			return presentation::FadeEffect_SPIRALOUT_LEFT;
		case presentation::AnimationEffect_SPIRALOUT_RIGHT:			return presentation::FadeEffect_SPIRALOUT_RIGHT;

		case presentation::AnimationEffect_DISSOLVE:				return presentation::FadeEffect_DISSOLVE;

		case presentation::AnimationEffect_WAVYLINE_FROM_LEFT:		return presentation::FadeEffect_WAVYLINE_FROM_LEFT;
		case presentation::AnimationEffect_WAVYLINE_FROM_TOP:		return presentation::FadeEffect_WAVYLINE_FROM_TOP;
		case presentation::AnimationEffect_WAVYLINE_FROM_RIGHT:		return presentation::FadeEffect_WAVYLINE_FROM_RIGHT;
		case presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM:	return presentation::FadeEffect_WAVYLINE_FROM_BOTTOM;

		default:
		{
			DBG_ASSERT(0, "EffectAToF fehlgeschlagen");
			return presentation::FadeEffect_NONE;
		}
	}
}

// -----------------------------------------------------------------------------

MoveSpeed FuSlideShow::SpeedAToM(presentation::AnimationSpeed eSpeed)
{
	switch(eSpeed)
	{
		case presentation::AnimationSpeed_SLOW:	 return MOVE_SPEED_SLOW;
		case presentation::AnimationSpeed_MEDIUM: return MOVE_SPEED_MEDIUM;
		case presentation::AnimationSpeed_FAST:	 return MOVE_SPEED_FAST;

		default:
		{
			DBG_ASSERT(0, "SpeedAToM fehlgeschlagen");
			return MOVE_SPEED_SLOW;
		}
	}
}

// -----------------------------------------------------------------------------

FadeSpeed FuSlideShow::SpeedAToF(presentation::AnimationSpeed eSpeed)
{
	switch(eSpeed)
	{
		case presentation::AnimationSpeed_SLOW:	 return FADE_SPEED_SLOW;
		case presentation::AnimationSpeed_MEDIUM: return FADE_SPEED_MEDIUM;
		case presentation::AnimationSpeed_FAST:	 return FADE_SPEED_FAST;

		default:
		{
			DBG_ASSERT(0, "SpeedAToF fehlgeschlagen");
			return FADE_SPEED_SLOW;
		}
	}
}

// -----------------------------------------------------------------------------

BOOL FuSlideShow::Dim(SdrAttrObj* pObject, Point aPos, const Color& rDimColor)
{
	VirtualDevice		aDimVDev( *pShowWindow );
	MapMode				aMapMode( pShowWindow->GetMapMode() );
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo( pObject );
	BOOL				bAbort = FALSE;

	aMapMode.SetOrigin( Point( -aDimRect.Left(), -aDimRect.Top() ) );
	aDimVDev.SetMapMode( aMapMode );

	bAbort = !aDimVDev.SetOutputSize( aDimRect.GetSize() );

	if( bAbort )
		HandleError( STR_NOT_ENOUGH_MEMORY );
	else
	{
		BOOL bIsSlow = ( GetSlowObjRecord( pObject ) != NULL );

		aDimVDev.DrawOutDev( aDimRect.TopLeft(), aDimRect.GetSize(), aDimRect.TopLeft(), aDimRect.GetSize(), *pVDev );
		pMetaFile->Play( &aDimVDev, FIRST_START, OBJ_START( pObject, bIsSlow ) );
		PaintDimmedObject( pObject, &aDimVDev, pInfo->aDimColor, TRUE );

		// Clipping auf Seitenbereich
		Point aUpperLeft(pActualPage->GetLftBorder(), pActualPage->GetUppBorder());
		Point aLowerRight(pActualPage->GetSize().Width() - pActualPage->GetRgtBorder(),
						  pActualPage->GetSize().Height() - pActualPage->GetLwrBorder());
		Rectangle aClip(aUpperLeft, aLowerRight);
		Rectangle aRect( aDimRect );
		aRect.Intersection( aClip );
		pMetaFile->Play( &aDimVDev, OBJ_END( pObject, bIsSlow ), MTF_END );
		pShowWindow->DrawOutDev( aRect.TopLeft(), aRect.GetSize(), aRect.TopLeft(), aRect.GetSize(), aDimVDev );
	}

	// merken: Objekt ist jetzt abgeblendet
	pInfo->bDimmed = TRUE;

	return !bAbort;
}

// -----------------------------------------------------------------------------

void FuSlideShow::DimLayoutParagraph()
{
	if( pDimObject )
	{
		BOOL bIsSlowObj = IsSlowObj( pLayoutText );

		/****************************************************************
		|* Hintergrund und Objekte bis ausschliesslich Gliederung zeichnen
		\***************************************************************/
		pAnmVDev->SetClipRegion(aDimRect);
		pAnmVDev->DrawOutDev( aDimRect.TopLeft(), aDimRect.GetSize(), aDimRect.TopLeft(), aDimRect.GetSize(), *pVDev );
		pMetaFile->Play( pAnmVDev, FIRST_START, OBJ_START( pLayoutText, bIsSlowObj ) );
		pAnmVDev->SetClipRegion();

		/****************************************************************
		|* naechsten Absatz des Layout-Clone attributieren
		\***************************************************************/
		DimParas( pLayoutClone, nDimPos, nParaPos - 1 );

		/****************************************************************
		|* Auf dem Animationsdevice darstellen. Da hier auf dem Animations-
		|* device gearbeitet wird, darf nur der abzublendende Absatz neu
		|* gezeichnet werden. Das vollstaendige Zeichnen der Hintergrund-
		|* flaeche muss also temporaer ausgeschaltet werden.
		\***************************************************************/
		const BOOL bOldFullBckgnd = bFullBckgnd;
		bFullBckgnd = FALSE;
		PaintLayoutClone( pAnmVDev );
		bFullBckgnd = bOldFullBckgnd;

		/****************************************************************
		|* Jetzt die darueber liegenden Objekte aus dem Metafile zeichnen,
		|* aber nur im Bereich des Absatzes. Der Rest des Animationsdevice
		|* muss fuer das Einblenden der restlichen Absaetze unangetastet
		|* bleiben.
		\***************************************************************/
		pAnmVDev->SetClipRegion( aDimRect );
		pMetaFile->Play( pAnmVDev, OBJ_END( pLayoutText, bIsSlowObj ), MTF_END );
		pAnmVDev->SetClipRegion();

		// einblenden, dabei auf Seitenbereich clippen
		Point aUpperLeft( pActualPage->GetLftBorder(), pActualPage->GetUppBorder() );
		Point aLowerRight( pActualPage->GetSize().Width() - pActualPage->GetRgtBorder(),
						   pActualPage->GetSize().Height() - pActualPage->GetLwrBorder() );

        pShowWindow->Push( PUSH_CLIPREGION );
		pShowWindow->SetClipRegion( Rectangle( aUpperLeft, aLowerRight ) );
		pShowWindow->DrawOutDev( aDimRect.TopLeft(), aDimRect.GetSize(), aDimRect.TopLeft(), aDimRect.GetSize(), *pAnmVDev );
        pShowWindow->Pop();

		// merken: Objekt ist (teilweise) abgeblendet
		pDoc->GetAnimationInfo( pLayoutText )->bDimmed = TRUE;
	}
}

// -----------------------------------------------------------------------------

void FuSlideShow::DimParas( SdrTextObj* pTextObj, ULONG nFromPara, ULONG nToPara, Color* pColor )
{
	Color               aDimColor( COL_BLACK );
	SdAnimationInfo*    pInfo = ( (SdDrawDocument*) pTextObj->GetModel() )->GetAnimationInfo(pTextObj);
    SdOutliner*         pOutl = pDoc->GetInternalOutliner();
	OutlinerParaObject* pOPO = pTextObj->GetOutlinerParaObject();
	
    if( pColor )
		aDimColor = *pColor;
	else if ( pInfo )
		aDimColor = pInfo->aDimColor;

    if( pOutl && pOutl->GetParagraphCount() && pOPO )
    {
        pOutl->Clear();
        pOutl->SetText( *pOPO );

        const USHORT nMinPara = (USHORT) Min( nFromPara, pOutl->GetParagraphCount() - 1 );
        const USHORT nMaxPara = (USHORT) Min( nToPara, pOutl->GetParagraphCount() - 1 );

        for( USHORT i = nMinPara; i <= nMaxPara; i++ )
        {
            const ESelection    aSel( i, 0, i, 0xffff );
	        SfxItemSet          aSet( ( (EditEngine&) pOutl->GetEditEngine() ).GetAttribs( aSel ) );

            aSet.Put( SvxColorItem( aDimColor, EE_CHAR_COLOR ) );

			if( aSet.GetItemState( EE_PARA_BULLET ) == SFX_ITEM_SET )
			{
				SvxBulletItem aBulletItem( (SvxBulletItem&) aSet.Get( EE_PARA_BULLET ) );

				if( aBulletItem.GetStyle() != BS_NONE )
				{
					Font aFont( aBulletItem.GetFont() );
                    aFont.SetColor( aDimColor );
					aBulletItem.SetFont( aFont );
					aSet.Put( aBulletItem );
				}
			}

            pOutl->QuickSetAttribs( aSet, aSel );
        }
        
        pTextObj->SetOutlinerParaObject( pOutl->CreateParaObject() );
	    pOutl->Clear();
    }
}

// -----------------------------------------------------------------------------

void FuSlideShow::StartSound( const String& rSound )
{
	if( rSound.Len() )
	{
		// falls der Sound vollstaendig abgespielt werden soll, muessen Key-,
		// Mouse- und Timer-Events blockiert werden; dies aber nur in der Show
		if( bPlayFull && ( eAnimationMode == ANIMATIONMODE_SHOW ) && ( !pSound || !pSound->IsPlaying() ) )
			nIgnoreInputSmph++;

		delete pSound;
		pSound = new Sound;
		pSound->SetNotifyHdl( LINK( this, FuSlideShow, SoundHasStoppedHdl ) );
		pSound->SetSoundName( rSound );
		pSound->Play();

		// hat irgendetwas nicht geklappt, muessen wir den Handler
		// rufen, damnit interne Aufraeumarbeiten stattfinden
		// und Eingaben wieder ausgewertet werden
		if( pSound->GetLastError() )
		{
			pSound->Stop();
			pSound->GetNotifyHdl().Call( pSound );
		}
	}
    else
        bPlayFull = FALSE;
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideShow, SoundHasStoppedHdl, void *, EMPTYARG )
{
	pSound->SetNotifyHdl( Link() );
	pSound->ClearError();
	pSound->SetSoundName( String() );

	// wenn ein TimerCall abgefangen wurde, den Call jetzt ausfuehren
	if( bTimerIntercepted )
	{
		bTimerIntercepted = FALSE;
		aTimer.SetTimeout( 50 );
		aTimer.Start();
	}

	// falls der Sound vollstaendig abgespielt werden soll, muessen Key-,
	// Mouse- und Timer-Events blockiert werden; dies aber nur in der Show
	if( bPlayFull && ( eAnimationMode == ANIMATIONMODE_SHOW ) && nIgnoreInputSmph )
		nIgnoreInputSmph--;

	bPlayFull = FALSE;

	return 0L;
}

// -----------------------------------------------------------------------------

void FuSlideShow::DeleteClientList()
{
	if (pClientList != NULL)
	{
		for (USHORT n = 0; n < pClientList->Count(); n++)
		{
		   pClientList->GetObject(n)->DoDisconnect();
		}

		delete pClientList;
		pClientList = NULL;
	}
}

// -----------------------------------------------------------------------------

void FuSlideShow::PrepareForPage( SdPage* pPage, BOOL bInitAnimObjs )
{
	if( bNativeMode && eAnimationMode == ANIMATIONMODE_SHOW )
		pShowWindow->DrawWaitIcon();

	// ungueltige Seite (z.B. am Ende der Show)?
	if( pPage )
	{
		List	aMasterShowStatusList;
		SdPage* pMaster = (SdPage*) pPage->GetMasterPage( 0 );
		BOOL	bEnableOutput = FALSE;

		// swap in all objects
		pMaster->SwapInAll();
		pPage->SwapInAll();

		pBckgndRect = pMaster->GetPresObj( PRESOBJ_BACKGROUND );

		// ggfs. Animationsobjekte finden
		if( bInitAnimObjs )
		{
			DBG_ASSERT( pNextAnmList, "keine Animationsliste!" );

			pNextAnmList->Clear();
			pNextAnimGraphs->Clear();
			pNextControls->Clear();
			aAnimObjsBoundRect = Rectangle();
			FindSpecialObjects( pMaster, bEnableOutput );
			FindSpecialObjects( pPage, bEnableOutput );
		}

		// Metafile fuer die Seite erzeugen, dabei Showstati in den Animationsinfos initialisieren
		pShowView->SetAnimationEnabled( FALSE );
		bInitShowStatus = bInitAnimObjs;
		CreateMarkerMetaFile( pPage, bEnableOutput );
		bInitShowStatus = FALSE;

		if( bInitAnimObjs )
		{
			// alte ShowStati der MasterPage-Objekte sichern und neu setzen
			SdrObjListIter aMasterIter( *pPage->GetMasterPage( 0 ), IM_FLAT );
			for( SdrObject* pMasterO = aMasterIter.Next(); pMasterO; pMasterO = aMasterIter.Next() )
			{
				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pMasterO );

				if( pInfo )
				{
					aMasterShowStatusList.Insert( new SdShowStatus( pInfo ) );
					InitShowStatus( pInfo );
				}
			}
		}

		RepaintVDev( pPage, FALSE );

		if( aMasterShowStatusList.Count() )
		{
			for( void* p = aMasterShowStatusList.First(); p; p = aMasterShowStatusList.Next() )
			{
				SdShowStatus* pStatus = (SdShowStatus*) p;

				pStatus->pInfo->bShow = pStatus->bShow;
				pStatus->pInfo->bIsShown = pStatus->bIsShown;
				pStatus->pInfo->bDimmed = pStatus->bDimmed;
				delete pStatus;
			}
		}

		pShowView->SetAnimationEnabled( TRUE );
		aAnimPageList.SetPreparedPageNum( ( pPage->GetPageNum() - 1 ) / 2 );
	}

	if( bNativeMode && eAnimationMode == ANIMATIONMODE_SHOW )
		pShowWindow->ClearWaitIcon();
}

// -----------------------------------------------------------------------------

void FuSlideShow::SetPaintModes(SdrView* pSourceView, SdrView* pTargetView,
								ExtOutputDevice* pXOut,
								SdrPaintInfoRec* pPaintInfoRec)
{
	DBG_ASSERT(pSourceView, "keine SourceView");

	// Border
    BOOL bFlag = pSourceView->IsBordVisible();
	if (pTargetView)
		pTargetView->SetBordVisible(bFlag);

    // PageBorder
    bFlag = pSourceView->IsPageBorderVisible();
	if (pTargetView)
		pTargetView->SetPageBorderVisible(bFlag);

	// Liniendarstellung
	bFlag = pSourceView->IsLineDraft();
	if (pTargetView)
		pTargetView->SetLineDraft(bFlag);
	if (pXOut)
		pXOut->SetIgnoreLineAttr(bFlag);

	// Flaechendarstellung
	bFlag = pSourceView->IsFillDraft();
	if (pTargetView)
		pTargetView->SetFillDraft(bFlag);
	if (pXOut)
		pXOut->SetIgnoreFillAttr(bFlag);

	// Textdarstellung
	bFlag = pSourceView->IsTextDraft();
	if (pTargetView)
		pTargetView->SetTextDraft(bFlag);
	if (pPaintInfoRec)
	{
		if (bFlag)
			pPaintInfoRec->nPaintMode |= SDRPAINTMODE_DRAFTTEXT;
		else
			pPaintInfoRec->nPaintMode &= ~SDRPAINTMODE_DRAFTTEXT;
	}

	// Grafikdarstellung
	bFlag = pSourceView->IsGrafDraft();
	if (pTargetView)
		pTargetView->SetGrafDraft(bFlag);
	if (pPaintInfoRec)
	{
		if (bFlag)
			pPaintInfoRec->nPaintMode |= SDRPAINTMODE_DRAFTGRAF;
		else
			pPaintInfoRec->nPaintMode &= ~SDRPAINTMODE_DRAFTGRAF;
	}

	// hidden Grafikdarstellung
	bFlag = pSourceView->IsHideGrafDraft();
	if (pTargetView)
		pTargetView->SetHideGrafDraft(bFlag);
	if (pPaintInfoRec)
	{
		if (bFlag)
			pPaintInfoRec->nPaintMode |= SDRPAINTMODE_HIDEDRAFTGRAF;
		else
			pPaintInfoRec->nPaintMode &= ~SDRPAINTMODE_HIDEDRAFTGRAF;
	}
}

// -----------------------------------------------------------------------------

void FuSlideShow::ShowPlugIns()
{
	SdrObjListIter	aMasterIter( *pActualPage->GetMasterPage( 0 ), IM_FLAT );
	SdrObjListIter	aPageIter( *pActualPage, IM_DEEPWITHGROUPS );
	SdrObjListIter*	pIter = &aMasterIter;
	SdrObject*		pObject = NULL;

	for( long i = 0; i < 2; i++ )
	{
		while( pObject = pIter->Next() )
		{
			if( pObject->GetObjInventor() == SdrInventor && pObject->GetObjIdentifier() == OBJ_OLE2 )
			{
				const SvInPlaceObjectRef& rIPObjRef = ((SdrOle2Obj*)pObject)->GetObjRef();

				// OLE-Objekt kann leer sein, also mit Is() absichern
				if( rIPObjRef.Is() && rIPObjRef->GetMiscStatus() & SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE )
				{
					SvInPlaceClientRef pClient = rIPObjRef->GetIPClient();

					if( !pClient.Is() || ( pClient->GetEnv() && pClient->GetEnv()->GetEditWin() != pShowWindow ) )
					{
						pClient = new SfxInPlaceClient( pViewShell, pShowWindow );

						rIPObjRef->DoConnect(pClient);
						DoVerb( pObject, 0 );
						pClientList->Append( pClient );
					}
				}
			}
		}

		pIter = &aPageIter;
	}
}

// -----------------------------------------------------------------------------

void FuSlideShow::PaintDimmedObject( SdrAttrObj* pObject, OutputDevice* pOut,
									 const Color& rDimColor, BOOL bIgnoreTransparency )
{
	ExtOutputDevice		aOut( pOut );
	SdrPaintInfoRec		aPaintInfoRec;
	SdrObjGroup*		pClone;

	if( pObject->ISA( SdrObjGroup ) )
		pClone = (SdrObjGroup*) pObject->Clone();
	else
	{
		pClone = new SdrObjGroup;
		pClone->GetSubList()->NbcInsertObject( pObject->Clone() );
	}

	pClone->SetModel( pDoc );
	pClone->GetSubList()->SetObjOrdNumsDirty();

	SdrObjListIter aIter( *pClone->GetSubList(), IM_DEEPWITHGROUPS );
    typedef ::std::vector< SdrObject* > VectorOfSdrObjects;
    VectorOfSdrObjects aPendingDeletes;

	for( SdrObject*	pO = aIter.Next(); pO; pO = aIter.Next() )
	{
		if( !pO->ISA( SdrObjGroup ) )
		{
		    SdOutliner*         pOutl = pDoc->GetInternalOutliner();
			OutlinerParaObject* pOPO = pO->GetOutlinerParaObject();
			SfxItemSet          aAttr( pDoc->GetPool(), XATTR_LINESTYLE, XATTR_LINESTYLE,
											   XATTR_LINECOLOR, XATTR_LINECOLOR,
											   XATTR_LINETRANSPARENCE, XATTR_LINETRANSPARENCE,
											   XATTR_FILLSTYLE, XATTR_FILLSTYLE,
											   XATTR_FILLCOLOR, XATTR_FILLCOLOR,
											   XATTR_FILLGRADIENT, XATTR_FILLGRADIENT,
											   XATTR_FILLHATCH, XATTR_FILLHATCH,
											   XATTR_FILLTRANSPARENCE, XATTR_FILLTRANSPARENCE,
											   XATTR_FILLFLOATTRANSPARENCE, XATTR_FILLFLOATTRANSPARENCE,
											   SDRATTR_SHADOWCOLOR, SDRATTR_SHADOWCOLOR,
                                               SDRATTR_SHADOWTRANSPARENCE, SDRATTR_SHADOWTRANSPARENCE,
                                               SDRATTR_GRAFLUMINANCE, SDRATTR_GRAFLUMINANCE,
											   SDRATTR_GRAFCONTRAST, SDRATTR_GRAFCONTRAST,
											   SDRATTR_GRAFRED, SDRATTR_GRAFRED,
											   SDRATTR_GRAFGREEN, SDRATTR_GRAFGREEN,
											   SDRATTR_GRAFBLUE, SDRATTR_GRAFBLUE,
											   SDRATTR_GRAFGAMMA, SDRATTR_GRAFGAMMA,
											   SDRATTR_GRAFTRANSPARENCE, SDRATTR_GRAFTRANSPARENCE,
											   SDRATTR_GRAFINVERT, SDRATTR_GRAFINVERT,
  											   SDRATTR_GRAFMODE, SDRATTR_GRAFMODE,
                                               0, 0 );
            
			aAttr.Set( pO->GetItemSet() ); 

            if( pO->ISA( SdrTextObj ) )
                DimParas( (SdrTextObj*) pO, 0, 0xffff, (Color*) &rDimColor );

			if( bIgnoreTransparency )
			{
				aAttr.Put( SdrGrafTransparenceItem() );
				aAttr.Put( XFillFloatTransparenceItem() );
				aAttr.Put( XFillTransparenceItem() );
				aAttr.Put( XLineTransparenceItem() );
				aAttr.Put( SdrShadowTransparenceItem() );
			}

			if( pO->ISA( SdrOle2Obj ) )
			{
				GDIMetaFile	    aMtf;
				SdrOle2Obj*		pOle2Obj = static_cast< SdrOle2Obj* >( pO );
		        Rectangle       aBoundRect( pOle2Obj->GetBoundRect() );
				const sal_Bool  bOutputEnabled = pOut->IsOutputEnabled();
				
				pOut->EnableOutput( sal_False );
				pOut->Push();
			    aMtf.Record( pOut );
                pOle2Obj->Paint( aOut, aPaintInfoRec );
                aMtf.Stop();
			    aMtf.WindStart();
    		    aMtf.SetPrefMapMode( pOut->GetMapMode() );
		        aMtf.SetPrefSize( aBoundRect.GetSize() );
				pOut->Pop();
				pOut->EnableOutput( bOutputEnabled );

			    const Graphic   aMonoGraphic( aMtf.GetMonochromeMtf( rDimColor ) );
                SdrOle2Obj*     pNewObj = new SdrOle2Obj;
				
    			pO = pNewObj;
    			aAttr.ClearItem();
	    		aAttr.Set( pO->GetItemSet() ); 
                aBoundRect.Move( pOut->GetMapMode().GetOrigin().X() - aBoundRect.Left(), pOut->GetMapMode().GetOrigin().Y() - aBoundRect.Top() );
                
                pNewObj->SetLogicRect( aBoundRect );
                pNewObj->SetGraphic( &aMonoGraphic );

                // #110606# Delay deletion of SdrOleObjs until loop through ObjList is done
				aPendingDeletes.push_back( pClone->GetSubList()->NbcReplaceObject( pNewObj, pOle2Obj->GetOrdNum() ) );
			}
			else if( pO->ISA( SdrGrafObj ) )
			{
				SdrGrafObj*		pGrafObj = (SdrGrafObj*) pO;
				SdrGrafSetItem	aSetItem( &pDoc->GetItemPool() );
				SfxItemSet&		rSet = aSetItem.GetItemSet();

				rSet.Put( SdrGrafLuminanceItem( 0 ) );
				rSet.Put( SdrGrafContrastItem( 0 ) );
				rSet.Put( SdrGrafRedItem( 0 ) );
				rSet.Put( SdrGrafGreenItem( 0 ) );
				rSet.Put( SdrGrafBlueItem( 0 ) );
				rSet.Put( SdrGrafGamma100Item( 100 ) );
				rSet.Put( SdrGrafTransparenceItem( 0 ) );
				rSet.Put( SdrGrafInvertItem( FALSE ) );
				rSet.Put( SdrGrafModeItem( GRAPHICDRAWMODE_STANDARD ) );

				pGrafObj->SetItemSet(rSet);

				if( pGrafObj->GetGraphicType() == GRAPHIC_GDIMETAFILE )
					pGrafObj->SetGraphic( pGrafObj->GetGraphic().GetGDIMetaFile().GetMonochromeMtf( rDimColor ) );
				else if( pGrafObj->GetGraphicType() == GRAPHIC_BITMAP )
				{
					BitmapEx		aBmpEx( pGrafObj->GetGraphic().GetBitmapEx() );
					BitmapPalette	aPal( 3 );

					aPal[ 0 ] = Color( COL_BLACK );
					aPal[ 1 ] = Color( COL_WHITE );
					aPal[ 2 ] = rDimColor;

					Bitmap aBlack( aBmpEx.GetSizePixel(), 4, &aPal );
					aBlack.Erase( rDimColor );

					if( aBmpEx.IsAlpha() )
						pGrafObj->SetGraphic( BitmapEx( aBlack, aBmpEx.GetAlpha() ) );
					else
						pGrafObj->SetGraphic( BitmapEx( aBlack, aBmpEx.GetMask() ) );
				}
			}
			else
			{
				const XLineStyle eLineStyle = ( (const XLineStyleItem&) aAttr.Get( XATTR_LINESTYLE ) ).GetValue();
				const XFillStyle eFillStyle = ( (const XFillStyleItem&) aAttr.Get( XATTR_FILLSTYLE ) ).GetValue();

				if( eLineStyle != XLINE_NONE )
					aAttr.Put( XLineColorItem( String(), rDimColor ) );

				if( XFILL_SOLID == eFillStyle || XFILL_BITMAP == eFillStyle )
				{
					aAttr.Put( XFillStyleItem( XFILL_SOLID ) );
					aAttr.Put( XFillColorItem( String(), rDimColor ) );
				}
				else if( XFILL_HATCH == eFillStyle )
				{
					XHatch aHatch( ( (const XFillHatchItem&) aAttr.Get( XATTR_FILLHATCH ) ).GetValue() );
					aHatch.SetColor( rDimColor );
					aAttr.Put( XFillHatchItem( &pDoc->GetPool(), aHatch ) );
				}
				else if( XFILL_GRADIENT == eFillStyle )
				{
					XGradient aGradient( rDimColor, rDimColor, XGRAD_LINEAR, 0, 0, 0, 0, 100, 100, 3 );
					aAttr.Put( XFillGradientItem( &pDoc->GetPool(), aGradient ) );
				}

                aAttr.Put( SdrShadowColorItem( String(), rDimColor ) );
			}

			pO->SetItemSet(aAttr);

			if( pO->ISA( E3dScene ) )
			{
				E3dScene* pScene = (E3dScene*) pO;

				pScene->SetItem( SvxColorItem( rDimColor, SID_ATTR_3D_AMBIENTCOLOR ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_1, FALSE ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_2, FALSE ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_3, FALSE ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_4, FALSE ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_5, FALSE ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_6, FALSE ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_7, FALSE ) );
				pScene->SetItem( SfxBoolItem( SDRATTR_3DSCENE_LIGHTON_8, FALSE ) );

				pScene->SetRectsDirty();
				pScene->InitTransformationSet();
			}
		}
	}

    // #110606# Delay deletion of SdrOleObj until here. Beware, don't use 
    // the aIter below this point.
    VectorOfSdrObjects::iterator curr(aPendingDeletes.begin());
    const VectorOfSdrObjects::iterator end(aPendingDeletes.end());
    while( curr!=end )
        delete *curr++;

	SetPaintModes( (SdrView*) pView, NULL, &aOut, &aPaintInfoRec );

	const ULONG nOldDrawMode = pOut->GetDrawMode();
	ULONG		nNewDrawMode = pShowWindow->GetDrawMode();

	if( rDimColor == Color( COL_BLACK ) )
		nNewDrawMode |= DRAWMODE_BLACKTEXT;

	pOut->SetDrawMode( nNewDrawMode );
	pClone->Paint( aOut, aPaintInfoRec );
	pOut->SetDrawMode( nOldDrawMode );
	delete pClone;
}

// -----------------------------------------------------------------------------

void FuSlideShow::PaintLayoutClone(OutputDevice* pOut)
{

	// im Live-Modus kann die Gliederung in unvorhersehbarer Weise veraendert
	// worden sein --> LayoutClone aktualisieren
	// gleiches gilt fuer die Preview ( KA 14.02.97 )
	if ( !bNativeMode || ( ANIMATIONMODE_PREVIEW == eAnimationMode ) )
	{
		delete pLayoutClone;
		pLayoutClone = (SdrRectObj*) pLayoutText->Clone();
		
        if( nDimPos > 0 )
			DimParas( pLayoutClone, 0, nDimPos - 1 );

		// die sind damit ungueltig geworden
		delete pLayoutClip;
		pLayoutClip = NULL;
	}

	// Soll der LayoutClone immer mit voller Flaeche gezeichnet werden (z. B.
	// beim Lasereffekt)? Dann die Hintergrundflaeche ohne Clipping zeichnen.
	if (bFullBckgnd)
	{
		// einen Clone erzeugen
		SdrObject*		pClone = (SdrRectObj*)pLayoutClone->Clone();
		const Rectangle	aLogicRect( pClone->GetLogicRect() );

		// dessen Text loeschen
		pClone->NbcSetOutlinerParaObject(NULL);
		pClone->NbcSetLogicRect( aLogicRect );

		// jetzt den textlosen Clone zeichnen
		ExtOutputDevice aOut(pOut);
		SdrPaintInfoRec aPaintInfoRec;
		SetPaintModes((SdrView*)pView, NULL, &aOut, &aPaintInfoRec);
		const ULONG nOldDrawMode = pOut->GetDrawMode();
		pOut->SetDrawMode( pShowWindow->GetDrawMode() );
		pClone->Paint(aOut, aPaintInfoRec);
		pOut->SetDrawMode( nOldDrawMode );

		delete pClone;
	}

	// Der Clone enthaelt den gesamten Text, es ist aber nur ein Bruchteil
	// in der Show zu sehen. Darum: Clipping
	// falls noch nicht geschehen, ein Clipping-Rechteck bestimmen
	if ( !pLayoutClip )
	{
		Rectangle aRect( pLayoutClone->GetBoundRect() );
		Outliner& rOutliner = pDoc->GetDrawOutliner();

		if( nParaPos && nParaPos < pOutlInfo->GetParaCount() )
			aRect.Bottom() = pOutlInfo->GetParaRect( nParaPos - 1 ).Bottom();

		pLayoutClip = new PolyPolygon( aRect );
	}

	ExtOutputDevice aOut( pOut );
	Region			aOldClipRegion( pOut->GetClipRegion() );
	SdrPaintInfoRec aPaintInfoRec;
	BOOL			bClip = pOut->IsClipRegion();

	pOut->SetClipRegion( *pLayoutClip );
	SetPaintModes( (SdrView*) pView, NULL, &aOut, &aPaintInfoRec );
	const ULONG nOldDrawMode = pOut->GetDrawMode();
	pOut->SetDrawMode( pShowWindow->GetDrawMode() );
	pLayoutClone->Paint( aOut, aPaintInfoRec );
	pOut->SetDrawMode( nOldDrawMode );

	if( bClip )
		pOut->SetClipRegion( aOldClipRegion );
	else
		pOut->SetClipRegion();
}

// -----------------------------------------------------------------------------

void FuSlideShow::CreateMarkerMetaFile( SdPage* pPage, BOOL bEnableOutput )
{
	Rectangle aWorkArea(((SdrView*)pView)->GetWorkArea());

	SetPaintModes((SdrView*)pView, pShowView, NULL, NULL);
	pShowView->ShowPage(pPage, Point());

	SdrPageView*	pPageView = pShowView->GetPageView(pPage);
	SdViewShell*	pViewSh = GetDrawViewShellForShow();
	const Link		aPaintProcLink( LINK(this, FuSlideShow, PaintProc ) );

	if( pViewSh )
	{
		FrameView* pFrameView = pViewSh->GetFrameView();

		pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
		pPageView->SetLockedLayers( pFrameView->GetLockedLayers() );
		pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
	}

	// GCC kann keinen default-Point-ctor in der Parameterliste
	Point		aDefPoint;
	Rectangle	aRect( aDefPoint, pPage->GetSize() );

	aRect.Union( aAnimObjsBoundRect );
	Region aRegion( aRect );

	// Ersatzdarstellungen fuer langsame Objekte loeschen
	if( pSlowObjList )
	{
		ClearSlowObjList();
		delete pSlowObjList;
		pSlowObjList = NULL;
	}

	if( ( eAnimationMode == ANIMATIONMODE_SHOW ) && pViewShell && pViewShell->GetFrameView()->IsMasterPagePaintCaching() )
	{
		SdrObjListIter aMasterIter( *(SdPage*) pPage->GetMasterPage( 0 ), IM_FLAT );

		nMasterPageCacheMode = SDR_MASTERPAGECACHE_FULL;

		// nachsehen, ob auf der Masterpage animierte Objekte liegen; in diesem
		// Fall darf nur das reine Hintergrundobjekt gecached ausgegeben werden
		for( SdrObject* pMasterO = aMasterIter.Next(); pMasterO; pMasterO = aMasterIter.Next() )
		{
			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pMasterO );

			if( pInfo && pInfo->bActive &&
				( pInfo->eEffect != presentation::AnimationEffect_NONE ||
				  pInfo->eTextEffect != presentation::AnimationEffect_NONE ||
				  ( pInfo->eEffect == presentation::AnimationEffect_NONE && pInfo->bIsMovie ) ) )
			{
				nMasterPageCacheMode = SDR_MASTERPAGECACHE_BACKGROUND;
				break;
			}
		}
	}
	else
		nMasterPageCacheMode = SDR_MASTERPAGECACHE_NONE;

	delete pMetaFile;
	pMetaFile = new SdMetaFile( this );
	pVDev->SetDrawMode( pShowWindow->GetDrawMode() );
	pMetaFile->Record( pVDev );
	pMetaFile->InsertMarker( MTF_START );

	// Cache entweder loeschen oder ggf. neu initialisieren
	if( SDR_MASTERPAGECACHE_NONE == nMasterPageCacheMode )
		pShowView->ReleaseMasterPagePaintCache(), pShowView->SetMasterPagePaintCaching( FALSE );
	else if( pShowView->GetMasterPagePaintCacheMode() != nMasterPageCacheMode )
		pShowView->SetMasterPagePaintCaching( TRUE, nMasterPageCacheMode );
		
	const ULONG nOldGraphicManagerDrawMode = pShowView->GetGraphicManagerDrawMode();

	pVDev->EnableOutput( bEnableOutput );
	pShowView->SetGraphicManagerDrawMode( nOldGraphicManagerDrawMode | GRFMGR_DRAW_NO_SUBSTITUTE );

	SdrOutliner& rOutl=pDoc->GetDrawOutliner(NULL);
	rOutl.SetBackgroundColor( pPage->GetBackgroundColor(pPageView) );

	pPageView->InitRedraw( (USHORT) 0, aRegion, 0, &aPaintProcLink );
	pShowView->SetGraphicManagerDrawMode( nOldGraphicManagerDrawMode );
	pVDev->EnableOutput( TRUE );
	pMetaFile->InsertMarker( MTF_END );
	pMetaFile->Stop();
	pVDev->SetDrawMode( DRAWMODE_DEFAULT );
}

// -----------------------------------------------------------------------------

presentation::AnimationEffect FuSlideShow::RandomAnimationEffect(BOOL bShow) const
{
	presentation::AnimationEffect eEffect = presentation::AnimationEffect_NONE;

	while( eEffect == presentation::AnimationEffect_NONE )
	{
		eEffect = (presentation::AnimationEffect) ( Time().GetTime() % ANIMATION_EFFECT_COUNT);

		// verbotene Effekte filtern
		if ( bShow )
		{
			switch( eEffect )
			{
				case( presentation::AnimationEffect_RANDOM ):
				case( presentation::AnimationEffect_NONE ):
				case( presentation::AnimationEffect_PATH ):
				case( presentation::AnimationEffect_MOVE_FROM_LEFT ):
				case( presentation::AnimationEffect_MOVE_FROM_UPPERLEFT ):
				case( presentation::AnimationEffect_MOVE_FROM_TOP ):
				case( presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT ):
				case( presentation::AnimationEffect_MOVE_FROM_RIGHT ):
				case( presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT ):
				case( presentation::AnimationEffect_MOVE_FROM_BOTTOM ):
				case( presentation::AnimationEffect_MOVE_FROM_LOWERLEFT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_TOP ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT ):
					eEffect = presentation::AnimationEffect_NONE;
				break;

				default:
				break;
			}
		}
		else
		{
			switch( eEffect )
			{
				case( presentation::AnimationEffect_RANDOM ):
				case( presentation::AnimationEffect_NONE ):
				case( presentation::AnimationEffect_PATH ):
				case( presentation::AnimationEffect_MOVE_FROM_LEFT ):
				case( presentation::AnimationEffect_MOVE_FROM_UPPERLEFT ):
				case( presentation::AnimationEffect_MOVE_FROM_TOP ):
				case( presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT ):
				case( presentation::AnimationEffect_MOVE_FROM_RIGHT ):
				case( presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT ):
				case( presentation::AnimationEffect_MOVE_FROM_BOTTOM ):
				case( presentation::AnimationEffect_MOVE_FROM_LOWERLEFT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_TOP ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM ):
				case( presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT ):
					eEffect = presentation::AnimationEffect_NONE;
				break;

				default:
				break;
			}
		}
	}

	return eEffect;
}



