
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import java.util.StringTokenizer;
import org.netbeans.modules.openoffice.*;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.OperationPanel;
import org.netbeans.modules.openoffice.wizard.keys.NameKey;
import org.netbeans.modules.openoffice.wizard.keys.OperationKey;
import org.openide.nodes.*;
import java.util.Vector;
import org.openide.nodes.Node;


public class OperationNode extends LeafNode
    implements org.openide.nodes.Node.Cookie
{

    public OperationNode(NameKey namedkey)
    {
        super(namedkey);
        getCookieSet().add(this);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/operation");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        for(int j = 0; j < i; j++)
            s = s + "    ";

        OperationKey operationkey = (OperationKey)key;
        if(operationkey.isOneway())
            s = s + "[oneway] ";
        s = s + operationkey.getReturnType() + " ";
        s = s + getName() + " (";
        s = s + operationkey.getParameters() + ")";
        if(operationkey.getExceptions().length() > 0)
            s = s + " raises (" + operationkey.getExceptions() + ")";
        
        s = s + ";\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        OperationPanel operationpanel = new OperationPanel();
        operationpanel.setName(getName());
        OperationKey operationkey = (OperationKey)key;
        operationpanel.setExceptions(operationkey.getExceptions());
        operationpanel.setOneway(operationkey.isOneway());
        operationpanel.setParameters(operationkey.getParameters());
        operationpanel.setReturnType(operationkey.getReturnType());
        return operationpanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof OperationPanel)
        {
            OperationPanel operationpanel = (OperationPanel)BasePanel;
            OperationKey operationkey = (OperationKey)key;
            String s = operationpanel.getName();
            String s2 = operationpanel.getReturnType();
            String s3 = operationpanel.getParameters();
            String s4 = operationpanel.getExceptions();
            boolean flag = operationpanel.isOneway();
            if(!operationkey.getName().equals(s))
            {
                setName(s);
                operationkey.setName(s);
            }
           if(!operationkey.getExceptions().equals(s4))
                operationkey.setExceptions(s4);
            if(!operationkey.getParameters().equals(s3))
                operationkey.setParameters(s3);
            if(!operationkey.getReturnType().equals(s2))
                operationkey.setReturnType(s2);
            if(operationkey.isOneway() != flag)
                operationkey.setOneway(flag);
        }
    }

    public void generateImports(Vector Imports1)
    {  StringTokenizer st = new StringTokenizer(((OperationKey)key).getExceptions(),","); 
        while (st.hasMoreTokens())
        {    
                String Import = OOTools.replaceSubStrings(st.nextToken().trim(),"::", "/");
                if((Import.length() > 0) && (!Imports1.contains(Import)))
                 { 
                   Imports1.add(Import);
                 }  
        } 
        
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }      
    
  
    
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/operation";
}
