/*************************************************************************
 *
 *  $RCSfile: profile.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obr $ $Date: 2001/06/07 13:45:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VOS_PROFILE_HXX_
#define _VOS_PROFILE_HXX_

#ifndef _VOS_MACROS_HXX_
#   include <vos/macros.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#   include <rtl/ustring.hxx>
#endif
#ifndef _OSL_PROFILE_H_
#   include <osl/profile.h>
#endif

#ifdef _USE_NAMESPACE
namespace vos
{
#endif

class IProfile
{
public:

    IProfile() { }

    virtual ~IProfile() { }


    virtual sal_Bool    SAL_CALL readString(const sal_Char* pszSection, const sal_Char* pszEntry,
                                sal_Char* pszString, sal_uInt32 MaxLen,
                                const sal_Char* pszDefault) = 0;
    virtual sal_Bool    SAL_CALL readBool(const sal_Char* pszSection, const sal_Char* pszEntry,
                              sal_Bool Default) = 0;
    virtual sal_uInt32  SAL_CALL readIdent(const sal_Char* pszSection, const sal_Char* pszEntry,
                               sal_uInt32 FirstId, const sal_Char* Strings[],
                               sal_uInt32 Default) = 0;

    virtual sal_Bool    SAL_CALL writeString(const sal_Char* pszSection, const sal_Char* pszEntry,
                                const sal_Char* pszString) = 0;
    virtual sal_Bool    SAL_CALL writeBool(const sal_Char* pszSection, const sal_Char* pszEntry,
                              sal_Bool Value) = 0;
    virtual sal_Bool    SAL_CALL writeIdent(const sal_Char* pszSection, const sal_Char* pszEntry,
                               sal_uInt32 FirstId, const sal_Char* Strings[],
                               sal_uInt32 Value) = 0;

    virtual sal_Bool    SAL_CALL removeEntry(const sal_Char *pszSection, const sal_Char *pszEntry) = 0;

    virtual sal_uInt32  SAL_CALL getSectionEntries(const sal_Char *pszSection, sal_Char* pszBuffer, sal_uInt32 MaxLen) = 0;
    virtual sal_uInt32  SAL_CALL getSections(const sal_Char *pszSection, sal_Char* pszBuffer, sal_uInt32 MaxLen) = 0;
};

class IUProfile
{
public:

    IUProfile() { }

    virtual ~IUProfile() { }


    virtual sal_Bool    SAL_CALL readString(const ::rtl::OUString& ustrSection, const ::rtl::OUString& ustrEntry,
                                   ::rtl::OUString& strString, const ::rtl::OUString& ustrDefault) = 0;

    virtual sal_Bool    SAL_CALL readBool(const ::rtl::OUString& ustrSection, const ::rtl::OUString& ustrEntry, sal_Bool Default) = 0;

    virtual sal_uInt32  SAL_CALL readIdent(const ::rtl::OUString& ustrSection, const ::rtl::OUString& ustrEntry,
                                  sal_uInt32 FirstId, const ::rtl::OUString*& ustrStrings,
                                  sal_uInt32 Default) = 0;

    virtual sal_Bool    SAL_CALL writeString(const ::rtl::OUString& ustrSection, const ::rtl::OUString& ustrEntry, const ::rtl::OUString& ustrString) = 0;
    virtual sal_Bool    SAL_CALL writeBool(const ::rtl::OUString& ustrSection, const ::rtl::OUString& ustrEntry, sal_Bool Value) = 0;
    virtual sal_Bool    SAL_CALL writeIdent(const ::rtl::OUString& ustrSection, const ::rtl::OUString& ustrEntry, sal_uInt32 FirstId, const ::rtl::OUString*& ustrStrings,
                                   sal_uInt32 Value) = 0;

    virtual sal_Bool    SAL_CALL removeEntry(const ::rtl::OUString& szSection, const ::rtl::OUString& ustrEntry) = 0;

    virtual sal_Bool  SAL_CALL getSectionEntries(const ::rtl::OUString& ustrSection, ::rtl::OUString& ustrBuffer ) = 0;
    virtual sal_Bool  SAL_CALL getSections(const ::rtl::OUString& ustrSection, ::rtl::OUString& ustrBuffer) = 0;

};

class OProfile : public NAMESPACE_VOS(IProfile)
{
public:
    enum TProfileOption
    {
        TOption_Default   = osl_Profile_DEFAULT,
        TOption_System    = osl_Profile_SYSTEM,
        TOption_ReadLock  = osl_Profile_READLOCK,
        TOption_WriteLock = osl_Profile_WRITELOCK,
        TOption_FlushWrite = osl_Profile_FLUSHWRITE
    };

    /// Creates profile
    OProfile();

    /// Create and open a profile
    OProfile(const ::rtl::OUString& strProfileName, TProfileOption Options = TOption_Default);

    /// Implicitly close profile
    virtual ~OProfile();

    sal_Bool    SAL_CALL open(const ::rtl::OUString& strProfileName, TProfileOption Options = TOption_Default);
    void        SAL_CALL close();

    virtual sal_Bool    SAL_CALL readString(const sal_Char* pszSection, const sal_Char* pszEntry,
                                    sal_Char* pszString, sal_uInt32 MaxLen,
                                    const sal_Char* pszDefault);
    virtual sal_Bool    SAL_CALL readBool(const sal_Char* pszSection, const sal_Char* pszEntry,
                                    sal_Bool Default);
    virtual sal_uInt32  SAL_CALL readIdent(const sal_Char* pszSection, const sal_Char* pszEntry,
                                    sal_uInt32 FirstId, const sal_Char* Strings[],
                                    sal_uInt32 Default);

    virtual sal_Bool    SAL_CALL writeString(const sal_Char* pszSection, const sal_Char* pszEntry,
                                    const sal_Char* pszString);
    virtual sal_Bool    SAL_CALL writeBool(const sal_Char* pszSection, const sal_Char* pszEntry,
                                    sal_Bool Value);
    virtual sal_Bool    SAL_CALL writeIdent(const sal_Char* pszSection, const sal_Char* pszEntry,
                                    sal_uInt32 FirstId, const sal_Char* Strings[],
                                    sal_uInt32 Value);

    virtual sal_Bool    SAL_CALL removeEntry(const sal_Char *pszSection, const sal_Char *pszEntry);

    virtual sal_uInt32  SAL_CALL getSectionEntries(const sal_Char *pszSection, sal_Char* pszBuffer, sal_uInt32 MaxLen);
    virtual sal_uInt32  SAL_CALL getSections(const sal_Char *pszSection, sal_Char* pszBuffer, sal_uInt32 MaxLen);

    virtual sal_Bool    SAL_CALL flush();

protected:
    oslProfile  m_hProfile;

private:

    // disable copy/assignment
    OProfile(const OProfile&);
    OProfile& SAL_CALL operator= (const OProfile&);
};

#ifdef _USE_NAMESPACE
}
#endif


#endif  //_VOS_PROFILE_HXX_



