/*************************************************************************
 *
 *  $RCSfile: wincidl.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "winshell.hxx"

//****************************************************************************
// CItemIDList
//****************************************************************************

//----------------------------------------------------------------------------
// Constructors
//----------------------------------------------------------------------------

CItemIDList::CItemIDList() :
m_pidl( NULL ),
m_nFolder( CSIDL_UNKNOWN )
{
	m_pidl = (LPITEMIDLIST)WIN_SHAlloc( sizeof(USHORT) + sizeof(USHORT) );
	if ( m_pidl )
	{
		m_pidl->mkid.cb = 2;
		m_pidl->mkid.abID[0] = 0;
		m_pidl->mkid.abID[1] = 0;
	}
};

//----------------------------------------------------------------------------

CItemIDList::CItemIDList( const CItemIDList & rList ) :
m_pidl( NULL ),
m_nFolder( CSIDL_UNKNOWN )
{
	WIN_SHCloneIDList( rList, &m_pidl );
	m_nFolder = rList.m_nFolder;
}

//----------------------------------------------------------------------------

CItemIDList::CItemIDList( LPCITEMIDLIST pidl ) :
m_pidl( NULL ),
m_nFolder( CSIDL_UNKNOWN )
{
	WIN_SHCloneIDList( pidl, &m_pidl );
}

//----------------------------------------------------------------------------

CItemIDList::CItemIDList( int nFolder ) :
m_pidl( NULL ),
m_nFolder( CSIDL_UNKNOWN )
{
	int	nWinFolder = -1;

	switch ( nFolder )
	{
	case CSIDL_ROOT:
		nWinFolder = CSIDL_DESKTOP;
		break;
	case CSIDL_SYSTEM:
		nWinFolder = CSIDL_DRIVES;
		break;
	case CSIDL_UNKNOWN:
	default:
		nWinFolder = nFolder;
		break;
	};


	if ( WIN_SHGetSpecialFolderLocation( nWinFolder, &m_pidl ) )
		m_nFolder = nFolder;
}

//----------------------------------------------------------------------------

CItemIDList::CItemIDList( const String & rPath ) :
m_pidl( NULL ),
m_nFolder( CSIDL_UNKNOWN )
{
	WIN_SHGetIDListFromPath( rPath.GetStr(), &m_pidl );
}

//----------------------------------------------------------------------------
// Destructor
//----------------------------------------------------------------------------

CItemIDList::~CItemIDList()
{
	if ( m_pidl )
		WIN_SHFree( m_pidl );
}

//----------------------------------------------------------------------------
// Assignement
//----------------------------------------------------------------------------

CItemIDList &CItemIDList::operator = ( const CItemIDList & rIDList )
{
	if ( m_pidl && m_pidl != rIDList.m_pidl )
	{
		WIN_SHFree( m_pidl );
		m_pidl = NULL;
		WIN_SHCloneIDList( rIDList, &m_pidl );
		m_nFolder = rIDList.m_nFolder;
	}

	return *this;
}

//----------------------------------------------------------------------------
// Concatenation
//----------------------------------------------------------------------------

CItemIDList &CItemIDList::operator += ( const CItemIDList & rIDList )
{
	// HRO: Sicherheitsabfrage um bei ungueltigen Pfaden keinen GPF zu erzeugen

	if (m_pidl &&  m_pidl->mkid.cb == sizeof(USHORT) )
		m_pidl->mkid.cb = 0;

	WIN_SHAppendIDList( rIDList, &m_pidl );
	m_nFolder = rIDList.m_nFolder;
	return *this;
}

//----------------------------------------------------------------------------
// Comparison
//----------------------------------------------------------------------------

int CItemIDList::operator == ( const CItemIDList & rIDList ) const
{
	return (WIN_SHCompareIDList( m_pidl, rIDList.m_pidl ) == 0 && m_nFolder == m_nFolder);
}

//----------------------------------------------------------------------------
// Token
//----------------------------------------------------------------------------

int CItemIDList::GetTokenCount() const
{
	return WIN_SHGetIDListTokenCount( m_pidl );
}

//----------------------------------------------------------------------------

CItemIDList CItemIDList::GetToken( int nToken ) const 
{
	LPITEMIDLIST	pidl = NULL;;
	CItemIDList		aIDList;

	WIN_SHGetIDListToken( m_pidl, nToken, &pidl );

	if ( pidl )
	{
		aIDList = CItemIDList( pidl );
		WIN_SHFree( pidl );
	}

	return aIDList;
}

//----------------------------------------------------------------------------
// Splitting
//----------------------------------------------------------------------------

CItemIDList CItemIDList::GetParent( int nLevelFromBottom ) const 
{
	LPITEMIDLIST	pidl = NULL;
	CItemIDList		aIDList;
	int				nLevelFromTop = GetTokenCount() - nLevelFromBottom;

	if ( nLevelFromBottom == 0 )
		return *this;

	if ( nLevelFromTop < 0 )
		nLevelFromTop = 0;

	if ( WIN_SHSplitIDListEx( m_pidl, &pidl, NULL, nLevelFromTop ) )
	{
		aIDList = CItemIDList( pidl );
		aIDList.m_nFolder = m_nFolder;
		WIN_SHFree( pidl );
	}

	return aIDList;
}

//----------------------------------------------------------------------------

CItemIDList CItemIDList::GetChild( int nLevelFromBottom ) const 
{
	LPITEMIDLIST	pidl = NULL;
	CItemIDList		aIDList;
	int				nLevelFromTop = GetTokenCount() - nLevelFromBottom;

	if ( nLevelFromTop < 0 )
		nLevelFromTop = 0;

	if ( nLevelFromTop == 0 )
		return *this;

	if ( WIN_SHSplitIDListEx( m_pidl, NULL, &pidl, nLevelFromTop ) )
	{
		aIDList = CItemIDList( pidl );
		WIN_SHFree( pidl );
	}

	return aIDList;
}

//----------------------------------------------------------------------------

void CItemIDList::Split( CItemIDList & rParent, CItemIDList & rChild, int nLevelFromBottom ) const 
{
	LPITEMIDLIST	pidlParent = NULL;
	LPITEMIDLIST	pidlChild = NULL;
	int				nLevelFromTop = GetTokenCount() - nLevelFromBottom;

	if ( nLevelFromTop < 0 )
		nLevelFromTop = 0;

	if ( WIN_SHSplitIDListEx( m_pidl, &pidlParent, &pidlChild, nLevelFromTop ) )
	{
		rParent = pidlParent;
		rParent.m_nFolder = m_nFolder;
		rChild = pidlChild;
		WIN_SHFree( pidlParent );
		WIN_SHFree( pidlChild );
	}
}

//----------------------------------------------------------------------------
//	GetFilePath
//----------------------------------------------------------------------------

String CItemIDList::GetFilePath() const
{
	TCHAR	szPath[MAX_PATH];

	if ( WIN_SHGetPathFromIDList( m_pidl, szPath ) )
		return String( szPath );
	else
		return String();
}
