/*************************************************************************
 *
 *  $RCSfile: rspwizard.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: dv $ $Date: 2001/10/05 08:46:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif

#include "main.hxx"

#include "agenda.hxx"
#include "action.hxx"
#include "decltor.hxx"
#include "environ.hxx"
#include "script.hxx"

#include "respfile.hxx"

// -----------------------------------------------------------------------

BOOL SetupApp::CallResponsePlugins( SiModule* pMod, SiDoneList& rDoneList )
{
	if( pMod->GetCustomList().Count() )
	{
		for(USHORT i = 0; i < pMod->GetCustomList().Count(); ++i)
		{
			SiCustom* pItem = pMod->GetCustomList().GetObject(i);
			if( !pItem->IsResponsefileWizard() || rDoneList.Find(pItem->GetDllName()) != 0 )
				continue;
			rDoneList.Insert(pItem->GetDllName(), 1);

			SiCustomAction* pNew = new SiCustomAction( NULL, pMod, pItem->GetDllName(),
							m_pEnv->GetStartPath(), FALSE, FALSE, pItem, m_pCompiledScript );

			if( !pNew->Execute(*m_pEnv) ) {
				delete pNew;
				return FALSE;
			}
			delete pNew;
		}
	}

	SiModuleList const* pModuleList = pMod->GetModuleList();
	for(USHORT x=0; x < pModuleList->Count(); ++x)
		if( !CallResponsePlugins( pModuleList->GetObject(x), rDoneList ) )
			return FALSE;

	return TRUE;
}

// -----------------------------------------------------------------------

BOOL SetupApp::FinishResponseFileWizard()
{
	SiDirEntry aEntry( m_pEnv->GetResponseFilename() );
	BOOL bExists = FALSE;
	if( aEntry.Exists() ) bExists = TRUE;

	m_pResponseFile->SetDestinationPath( m_pEnv->GetDestPath() );
	m_pResponseFile->Write( aEntry.GetFull() );

	Config aCfg( UniString(m_pEnv->GetResponseFilename(), osl_getThreadTextEncoding()) );
	aCfg.SetGroup( "JAVA" );
	aCfg.WriteKey( "JavaSupport", "preinstalled_or_none" );
	aCfg.Flush();

	SiDoneList aDoneList(1017);
	BOOL bSucc = CallResponsePlugins( m_pCompiledScript->GetRootModule(), aDoneList );
	if( !bSucc && !bExists )
		aEntry.Kill();

	return bSucc;
}

