/*************************************************************************
 *
 *  $RCSfile: pwsetup.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:09:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#include "maindlg.hxx"
#include "environ.hxx"

#include "pwsetup.hxx"
#include "pwsetup.hrc"

PageWrongSetup::PageWrongSetup( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aExpMark		( this, ResId(IMG_EXPMARK, rResId.GetResMgr()) ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTInfo3		( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	aFTInfo4		( this, ResId(FT_INFO4, rResId.GetResMgr()) ),
	aFTInfo5		( this, ResId(FT_INFO5, rResId.GetResMgr()) ),
	aCBRepair		( this, ResId(CB_REPAIR, rResId.GetResMgr()) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	pParent->SetTitleStr( aText );
	FreeResource();

	GETDLG()->SetAskOnExit( FALSE );

	Font aBold( aFTInfo1.GetFont() );
	aBold.SetWeight( WEIGHT_BOLD );

	aFTInfo2.SetFont( aBold );
	aFTInfo2.SetText(  UniString(GETDLG()->GetEnv()->GetInstalledPath(), osl_getThreadTextEncoding()) );

	aText = aFTInfo1.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
		UniString(GETDLG()->GetEnv()->GetProductName(), osl_getThreadTextEncoding()) );
	aFTInfo1.SetText( aText );

	aText = aFTInfo4.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
		UniString(GETDLG()->GetEnv()->GetProductName(),osl_getThreadTextEncoding()) );
	aFTInfo4.SetText( aText );

	aCBRepair.SetClickHdl( LINK(this, PageWrongSetup, ClickHdl) );
	if( !GETDLG()->GetEnv()->IsAutoRepair() )
	{
		aFTInfo5.Hide	( TRUE );
		aCBRepair.Hide	( TRUE );
	}

	GETDLG()->GetButtonNext()->Enable( FALSE );
}

PageWrongSetup::~PageWrongSetup()
{
}

SvAgentPage* PageWrongSetup::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageWrongSetup( pParent, rResId );
}

USHORT PageWrongSetup::GetReturnVal()
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();
	pEnv->SetInstallType( IT_RECOVER );

    return RETURN_REPAIR;
}

IMPL_LINK( PageWrongSetup, ClickHdl, Button*, pBtn )
{
	GETDLG()->GetButtonNext()->Enable( aCBRepair.IsChecked() );
	return 0;
}

