/*************************************************************************
 *
 *  $RCSfile: actionu.cxx,v $
 *
 *  $Revision: 1.14.114.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/23 17:33:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifdef UNX
#include <unistd.h>
#include <sys/stat.h>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef NOOLDSV //autogen
#include <vcl/system.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <tools/l2txtenc.hxx>

#include "decltor.hxx"
#include "action.hxx"
#include "environ.hxx"
#include "os.hxx"
#include "agenda.hxx"
#include "sihelp.hxx"

extern char SEP[];

// DeleteDirAction ---------------------------------------------------------
//

SiDeleteDirAction::SiDeleteDirAction
(
	SiAgenda* pAgenda,
	ByteString const& aRelPath,
	BOOL bDeleteAll                     /* = FALSE */
)
: SiAction(pAgenda, AT_RMDIR)
{
	m_aPath = aRelPath;
	m_bDeleteAll = bDeleteAll;
}

void _RemoveDirectory( ByteString aPath )
{
	Dir	aDir( aPath, FSYS_KIND_DIR | FSYS_KIND_FILE );
	for( USHORT i = 0; i < aDir.Count(); ++i )
	{
		SiDirEntry& rEntry= (SiDirEntry&)aDir[i];

		if( rEntry.GetFlag() != FSYS_FLAG_CURRENT &&
			rEntry.GetFlag() != FSYS_FLAG_PARENT )
		{
			FileStat aStat( rEntry, FALSE );
			if( aStat.IsKind(FSYS_KIND_DIR) )
				_RemoveDirectory( rEntry.GetFull() );

			OS::MakeWritable(rEntry.GetFull());
			rEntry.Kill();
		}
	}
	SiDirEntry aMaster( aPath );
	aMaster.Kill();
}

BOOL SiDeleteDirAction::Execute(SiEnvironment& Env)
{
	SiDirEntry  aDir		= Env.GetDestPath();
			  aDir	   += m_aPath;
	BOOL	  bExists   = aDir.Exists();
	FSysError nErr		= 0;

	if( bExists )
	{
		if( m_bDeleteAll )
			_RemoveDirectory( aDir.GetFull() );
		else
			nErr = aDir.Kill();
	}

	if( Env.GetInstallType() != IT_CHANGE || nErr == 0 )
	{
		GetLogfile()
	   	.Success(nErr==0)
			<< "rmdir " << aDir.GetFull();

		if (nErr!=0)
			GetLogfile() << " FSysError = " << nErr;

		if (!bExists)
			GetLogfile() << " (dir does not exists)" << nErr;

		GetLogfile() << endl;
	}

	return nErr == 0;
}

BOOL SiDeleteDirAction::operator < (const SiDeleteDirAction& rObj)
{
	// !!! VORSICHT Trick !!!
	// ich benutzte hier den > operator damit die Liste der Directorys
	// fuer die deinst. umgekehrt wird !!
	return m_aPath > rObj.GetName();
}

BOOL SiDeleteDirAction::operator == (const SiDeleteDirAction& rObj)
{
	return m_aPath == rObj.GetName();
}

// DeleteFileAction ------------------------------------------------
//
SiDeleteFileAction::SiDeleteFileAction
(
	SiAgenda* pAgenda,
	SiFile* pFile,
	ByteString const& aRelPath,
	ByteString const& aFile,
	const Date& aFileDate,
	const Time&	aFileTime,
	BOOL bCheckTime
)
: SiAction(pAgenda, AT_DELETE)
{
	m_aRelPath 	= aRelPath;
	m_aFile    	= aFile;
	m_pFile		= pFile; /* !!!!! kann NULL sein !!!!! */

	m_bTimeCheck = bCheckTime;
	m_aFileDate	= aFileDate;
	m_aFileTime	= aFileTime;
}

BOOL SiDeleteFileAction::CheckTimestamp( const SiDirEntry& rFile )
{
#ifdef UNX
	DateTime 	aDt = UnixOS::GetDateTime( rFile.GetFull() );
//	m_aFileTime.ConvertToLocal();
#else
	FileStat	aFileStat( rFile );
	Date 		aFDate( aFileStat.DateModified() );
	Time		aFTime( aFileStat.TimeModified() );
	DateTime	aDt( aFDate, aFTime );
#endif

// fprintf( stderr, "%d:%d:%d == ", aDt.GetYear(), aDt.GetMonth(), aDt.GetDay() );
// fprintf( stderr, "%d:%d:%d  >><< ", m_aFileDate.GetYear(), m_aFileDate.GetMonth(), m_aFileDate.GetDay() );
// fprintf( stderr, "%d:%d:%d == ", aDt.GetHour(), aDt.GetMin(), aDt.GetSec() );
// fprintf( stderr, "%d:%d:%d\n", m_aFileTime.GetHour(), m_aFileTime.GetMin(), m_aFileTime.GetSec() );

#ifdef WNT
    DateTime aOffset;
    if ( WinOS::NeedsOffsetCheck( aDt, aOffset ) &&
         ( aOffset.GetDate() == m_aFileDate.GetDate() ) &&
         ( aOffset.GetTime() == m_aFileTime.GetTime() ) )
        return TRUE;
#endif

	if( (aDt.GetDate() != m_aFileDate.GetDate()) || (aDt.GetTime() != m_aFileTime.GetTime()) )
	{
		GetLogfile().Success(TRUE) << "dont delete " << rFile.GetFull();
		GetLogfile() << " user modifyed" << endl;
		return FALSE;
	}
	return TRUE;
}

BOOL SiDeleteFileAction::DeleteDirectory( const SiDirEntry& rDir,
                                          BOOL bCheckTimestamp )
{
    if( !rDir.Exists() )
        return TRUE;

    USHORT      i;
    FSysError   nErr = 0;
    BOOL        bRet = TRUE;

    Dir aDirList( rDir, FSYS_KIND_DIR );

    for ( i=0; i< aDirList.Count(); i++ )
    {
        SiDirEntry& aTmp = (SiDirEntry&)aDirList[i];
        UniString aFile( aTmp.GetNameUni() );
        
        if( aFile.CompareToAscii(".") != COMPARE_EQUAL &&
            aFile.CompareToAscii("..") != COMPARE_EQUAL )
        {
            SiDirEntry aKillEntry( rDir );
            aKillEntry += aDirList[i];
            
#ifdef UNX
            ByteString aFile = aKillEntry.GetFull();
            struct stat aStat;
            if ( ! lstat( aFile.GetBuffer(), &aStat ) && S_ISLNK( aStat.st_mode ) )
            {
                // is really a link
                nErr = unlink( aFile.GetBuffer() );
                bRet = bRet && ( nErr == 0 );
                GetLogfile().Success( nErr==0 ) << "delete " << aKillEntry.GetFull();
            }
            else
#endif
            if ( DeleteDirectory( aKillEntry, bCheckTimestamp ) )
            {
                nErr = aKillEntry.Kill();
                bRet = bRet && ( nErr == 0 );
                GetLogfile().Success( nErr==0 ) << "delete " << aKillEntry.GetFull();
            }
        }
    }

    Dir aFileList( rDir, FSYS_KIND_FILE );

    for ( i=0; i<aFileList.Count(); i++ )
    {
        SiDirEntry aKillEntry( rDir );
        aKillEntry += aFileList[i];

        BOOL bKillIt = TRUE;
        if( m_pFile && bCheckTimestamp && m_pFile->CheckTimestamp() )
            bKillIt = CheckTimestamp( aKillEntry );

        if( bKillIt )
        {
            OS::MakeWritable( aKillEntry.GetFull() );
            nErr = aKillEntry.Kill();
            bRet = bRet && ( nErr== 0 );
            GetLogfile().Success(nErr==0) << "delete " << aKillEntry.GetFull();
        }
    }
    return bRet;
}

BOOL SiDeleteFileAction::Execute(SiEnvironment& Env)
{
	FSysError nErr = 0;

	if( m_pFile && m_pFile->GetName().CompareIgnoreCaseToAscii(README_ZIP) == COMPARE_EQUAL )
	{
		SiDirEntry aKill( Env.GetDestPath() );
		aKill += ByteString(LICENSE_FILE_NAME);
		aKill.Kill();
		GetLogfile() << " delete " << aKill.GetFull() << endl;

		aKill = Env.GetDestPath();
		aKill += ByteString(README_FILE_NAME);
		aKill.Kill();
		GetLogfile() << " delete " << aKill.GetFull() << endl;

		return TRUE;
	}

	// is this a DELETE_ONLY action with '*.*' will delete all files recursively!
	if( m_pFile && m_pFile->DeleteOnly() &&
		m_aFile.EqualsIgnoreCaseAscii( "*.*" ) )
	{
        SiDirEntry aDirectory = Env.GetDestPath();
		aDirectory += m_aRelPath;

		if( !aDirectory.Exists() )
			return TRUE;

		DeleteDirectory( aDirectory, Env.IsTimeCheck() );
		return TRUE;
	}
	// is this a DELETE_ONLY action with wildcards
	if( m_pFile && m_pFile->DeleteOnly() &&
		m_aFile.Search('*') != STRING_NOTFOUND || m_aFile.Search('?') != STRING_NOTFOUND )
	{
		SiDirEntry aDirectory = Env.GetDestPath();
		aDirectory += m_aRelPath;

		if( !aDirectory.Exists() )
			return TRUE;

		Dir aDir( aDirectory, FSYS_KIND_FILE );
		WildCard aMatch( UniString::CreateFromAscii(m_aFile.GetBuffer()) );

		for( USHORT i = 0; i < aDir.Count(); ++i )
		{
            SiDirEntry& aTmp = (SiDirEntry&)aDir[i];
			UniString aFile( aTmp.GetNameUni() );
			aFile.ToLowerAscii();
			if( aFile.CompareIgnoreCaseToAscii(".") != COMPARE_EQUAL &&
				aFile.CompareIgnoreCaseToAscii("..") != COMPARE_EQUAL &&
				aMatch == aFile )
			{
				SiDirEntry aKillEntry( aDirectory );
				aKillEntry += aDir[i];

				BOOL bKillIt = TRUE;
				if( m_pFile && Env.IsTimeCheck() && m_pFile->CheckTimestamp() )
					bKillIt = CheckTimestamp( aKillEntry );

				if( bKillIt )
				{
					OS::MakeWritable( aKillEntry.GetFull() );
					nErr = aKillEntry.Kill();
					GetLogfile().Success(nErr==0) << "delete " << aKillEntry.GetFull();
				}
			}
		}
		return TRUE;
	}

	// normal delete action
	SiDirEntry aFile  = Env.GetDestPath();
			 aFile += m_aRelPath;
			 aFile += m_aFile;

	BOOL	  bExists = aFile.Exists();

	if( bExists )
	{
		// UnoComponent
		if( Env.GetInstallType() == IT_CHANGE &&
			m_pFile && m_pFile->IsUnoComponent() )
		{
			ByteString aErrMsg;
			if( !SiHelp::RegisterUnoComponent( m_pFile, Env, FALSE, aErrMsg ) )
				GetLogfile().Success(FALSE) << "UNO exception (" << aFile.GetName() << "): " << aErrMsg << endl;
			SiHelp::DisposeUNOImpl();
		}

		BOOL bKillIt = TRUE;
		if( Env.IsTimeCheck() && m_bTimeCheck )
			bKillIt = CheckTimestamp( aFile );
		if( bKillIt )
		{
			OS::MakeWritable(aFile.GetFull());
			nErr = aFile.Kill();
		}
	}

	#ifdef OS2
	if( nErr )
	{
		Os2OS::ReplaceModule( aFile.GetFull().GetBuffer(), "" );
		nErr = aFile.Kill();
	}
	#endif

	// Infos fuer Unloader schreiben!
	if( nErr != 0 &&
		m_aFile.CompareIgnoreCaseToAscii("trayhook.dll") != COMPARE_EQUAL &&
		m_aFile.CompareIgnoreCaseToAscii("sointgr.exe") != COMPARE_EQUAL )
	{
		aFile.ToAbs();
		ADD_TO_DELFILE( Env, aFile.GetFull() );
	}

	GetLogfile().Success(nErr==0)
		<< "delete " << aFile.GetFull();

	if (nErr!=0)
		GetLogfile() << " FSysError = " << nErr;

	if (!bExists)
		GetLogfile() << " (file does not exist)";

	GetLogfile() << endl;

	return nErr == 0;
}

// DeleteFolderAction --------------------------------------------
//
SiDeleteFolderAction::SiDeleteFolderAction
(
	SiAgenda* pAgenda,
	ByteString const& aName,
	ByteString const& anOs2ID,
	SiFolder* pItem
)
: SiUnregisterAction(pAgenda)
{
	m_aName   = aName;
	m_anOs2ID = anOs2ID;
	m_pItem   = pItem;
}

BOOL SiDeleteFolderAction::Execute(SiEnvironment& rEnv)
{
#if defined WIN || defined WNT
	BOOL bSuccess = FALSE;

	USHORT nLanguage = m_pItem->GetLanguage();
	if( nLanguage == LANG_DEFAULT ) nLanguage = rEnv.GetDefLanguage();

	OUString aDirnameUNC;
    BOOL      bAllUser = rEnv.InstallForAllUser() && !rEnv.IsUpdateOldVersion();
	UniString aUniFolderName( m_aName, Langcode2TextEncoding(nLanguage) );
	UniString aDirname = WinOS::SHGetProgramFolder( bAllUser );

	aDirname += UniString::CreateFromAscii( "\\" );
	aDirname += aUniFolderName;

	FileBase::getFileURLFromSystemPath( aDirname, aDirnameUNC );

	bSuccess = Directory::remove( aDirnameUNC ) == FileBase::E_None? TRUE : FALSE;

	GetLogfile().Success( bSuccess ) <<
		"delete Folder :" << m_aName << endl;

	return bSuccess;
#else
	return FALSE;
#endif
}

// DeleteFoderItemAction --------------------------------------------
//
SiDeleteFolderItemAction::SiDeleteFolderItemAction
(
	SiAgenda* pAgenda,
	UniString const& aFolderName,
	ByteString const& anItemName,
	ByteString const& anOs2ID,
	SiFolderItem* pItem
)
: SiUnregisterAction(pAgenda)
{
	m_suFolderName = aFolderName;
	m_anItemName  = anItemName;
	m_anOs2ID     = anOs2ID;
	m_pItem 	  = pItem;
}


BOOL SiDeleteFolderItemAction::Execute(SiEnvironment& rEnv)
{
#if defined WIN || defined WNT
	BOOL bSuccess = FALSE;

	USHORT nLanguage = m_pItem->GetLanguage();
	if( nLanguage == LANG_DEFAULT ) nLanguage = rEnv.GetDefLanguage();

	UniString aUniFolderName( m_suFolderName );
	UniString aUniItemName( m_anItemName, Langcode2TextEncoding(nLanguage) );

	UniString aDirname;
	if( !m_pItem->GetFolder()->IsPredefined() )
    {
        // The old version didn't support all user install
        BOOL bAllUser = rEnv.InstallForAllUser() && !rEnv.IsUpdateOldVersion();
        aDirname = WinOS::SHGetProgramFolder( bAllUser );
    }
	else
		aDirname = aUniFolderName;

	if( !m_pItem->GetFolder()->IsPredefined() )
	{
		aDirname += UniString::CreateFromAscii( "\\" );
		aDirname += aUniFolderName;
	}
	aDirname += UniString::CreateFromAscii( "\\" );
	aDirname += aUniItemName;
	aDirname += UniString::CreateFromAscii( ".lnk" );

	OUString aDirnameUNC;
	FileBase::getFileURLFromSystemPath( aDirname, aDirnameUNC );

	bSuccess = File::remove( aDirnameUNC ) == FileBase::E_None? TRUE : FALSE;

	GetLogfile().Success( bSuccess )
		<< "delete FolderItem :" << ByteString(m_suFolderName, osl_getThreadTextEncoding()) << ", " << m_anItemName << endl;

	return bSuccess;
#else
	return FALSE;
#endif
}

// UninstallFontAction ----------------------------------------------
//

SiUninstallFontAction::SiUninstallFontAction
(
	SiAgenda* pAgenda,
	ByteString  const& aFontName,
	ByteString  const& aFontFile  // nur Dateiname
)
: SiUnregisterAction(pAgenda)
{
	m_aFontName = aFontName;
	m_aFontFile = aFontFile;
}

#if defined WIN || defined WNT || defined MAC

BOOL SiUninstallFontAction::Execute(SiEnvironment&)
{
	BOOL bSuccess = OS::UnInstallFont(m_aFontFile,m_aFontName);

	GetLogfile()
		.Success(bSuccess)
		<< "Uninstall font: "
		<< m_aFontFile << SEP
		<< m_aFontName << endl;

	return bSuccess;
}

#elif defined OS2

BOOL SiUninstallFontAction::Execute(SiEnvironment&)
{
	BOOL bSuccess = OS::UnInstallFont(m_aFontFile,m_aFontName);

	GetLogfile()
		.Success(bSuccess)
		<< "Uninstall font: "
		<< m_aFontFile << SEP
		<< m_aFontName << endl;

	return bSuccess;
}

#else

BOOL SiUninstallFontAction::Execute(SiEnvironment&)
{
	DBG_ERROR("SiUninstallFontAction::Execute() wrong platform");
	return FALSE;
}

#endif

// RegistryItemAction -----------------------------------------------
//
SiUnregisterAreaAction::SiUnregisterAreaAction
(
	SiAgenda     * pAgenda,
	ByteString  const& aSubKey,
	ByteString  const& aFromKey,
	ByteString  const& aToKey
)
: SiUnregisterAction(pAgenda)
{
	m_aSubKey  = aSubKey;
	m_aFromKey = aFromKey;
	m_aToKey   = aToKey;
}


#if defined (WIN) || defined (WNT)

BOOL SiUnregisterAreaAction::Execute(SiEnvironment&)
{
	long lErr = WinOS::ClearRegEdit(m_aSubKey, m_aFromKey,m_aToKey);

	GetLogfile()
		.Success(lErr==0)
		<< "clean registry: "
		<< m_aSubKey  << SEP
		<< m_aFromKey << SEP
		<< m_aToKey
		<< " Error = " << lErr
		<< endl;

	return lErr == 0;
}

#else // WIN/WNT

BOOL SiUnregisterAreaAction::Execute(SiEnvironment&)
{
	DBG_ERROR("SiUnregisterAreaAction::Execute()");
	GetLogfile() << "error: SiUnregisterAreaAction::Execute() called" << endl;
	return FALSE;
}

#endif // WIN/WNT

// ------------------------------------------------------------------
// OS/2 Aktionen
// ------------------------------------------------------------------

// Os2UnregisterClassAction -----------------------------------------
//

SiOs2UnregisterClassAction::SiOs2UnregisterClassAction
(
	SiAgenda    * pAgenda,
	ByteString const& aName
)
:SiUnregisterAction(pAgenda)
{
	m_aName = aName;
}

#ifdef OS2

BOOL SiOs2UnregisterClassAction::Execute(SiEnvironment& rEnv)
{
	ULONG lErr = Os2OS::DeregisterClass(m_aName);

	GetLogfile()
	   .Success(lErr==0)
		<< "unregister os/2 class: "
		<< m_aName;

	if (lErr != 0)
		GetLogfile() << " Err = " << lErr;

	GetLogfile() << endl;

	return SetSuccess(lErr==0);
}

#else

BOOL SiOs2UnregisterClassAction::Execute(SiEnvironment&)
{
	DBG_ERROR("Os2UnregisterClassAction::Execute() wrong platform");
	return TRUE;
}

#endif

// Os2DeleteTemplateAction ------------------------------------------
//

SiOs2DeleteTemplateAction::SiOs2DeleteTemplateAction
(
	SiAgenda    * pAgenda,
	ByteString const& anID
)
: SiUnregisterAction(pAgenda)
{
	m_anID = anID;
}

#ifdef OS2

BOOL SiOs2DeleteTemplateAction::Execute(SiEnvironment& rEnv)
{
	BOOL bSuccess = Os2OS::DeleteTemplate(m_anID);

	GetLogfile()
		.Success(bSuccess)
		<< "delete os/2 template: "
		<< m_anID
		<< endl;

	return SetSuccess(bSuccess);
}

#else

BOOL SiOs2DeleteTemplateAction::Execute(SiEnvironment&)
{
	DBG_ERROR("Os2CreateTemplateAction::Execute() wrong platform");
	return TRUE;
}

#endif

// ------------------------------------------------------------------
// Mac Aktionen
// ------------------------------------------------------------------

// MacDeleteApplicationAction ---------------------------------------
//

SiMacDeleteApplicationAction::SiMacDeleteApplicationAction
(
	SiAgenda      * pAgenda,
	ByteString const& aRelDir,
	ByteString const& aFileName,
	ByteString const& aCreator
)
: SiUnregisterAction(pAgenda)
{
	m_aRelDir    = aRelDir;
	m_aFileName  = aFileName;
	m_aCreator   = aCreator;
}

#ifdef MAC

BOOL SiMacDeleteApplicationAction::Execute(SiEnvironment& rEnv)
{
	SiDirEntry aFileDir  = rEnv.GetDestPath();
			 aFileDir += m_aRelDir;
			 aFileDir += m_aFileName;
	ByteString   aFile     = aFileDir.GetFull();

	BOOL bSuccess = MacOS::RemoveApplication(aFile, m_aCreator);

	GetLogfile()
		.Success(bSuccess)
		<< "mac delete app: "
		<< aFile      << SEP
		<< m_aCreator << endl;

	return SetSuccess(bSuccess);
}

#else

BOOL SiMacDeleteApplicationAction::Execute(SiEnvironment&)
{
	DBG_ERROR("MacDeleteApplicationAction::Execute() wrong platform");
	return TRUE;
}

#endif

